/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.lookup;

import java.util.List;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.lookup.HasLookupProxyImpl;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.lookup.IHasLookupProxy;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.ComposerHelper;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.Field;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.Method;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.Visibility;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.Method.Parameter;
import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;

public class HasLookupProxyGenerator extends Generator{

	private JClassType type;
	
	private ComposerHelper composerHelper;
	
	private String simpleClassName;
	
	@Override
	public String generate(TreeLogger logger, GeneratorContext context,
			String typeName) throws UnableToCompleteException {
	
		simpleClassName 		= type.getSimpleSourceName() + "_LookupProxy";
		
		composerHelper		   	= new ComposerHelper(context, logger, type.getPackage().getName(), simpleClassName);
		
		composerHelper.setSuperClass(typeName);
		composerHelper.addInterface(IHasLookupProxy.class);
		
		addMethods();
		
		composerHelper.commit();
		
		return composerHelper.getCreatedClassName();
	}
	
	private void addMethods(){
		
		Method contructor = new Method(Visibility.PUBLIC,simpleClassName);
		
		Field impl = new Field(Visibility.PRIVATE, HasLookupProxyImpl.class, "impl");

		
		contructor.getBody().instantiate(impl);

		
		Method registerObjectMethod = new Method(Visibility.PUBLIC, void.class, "register");
		Parameter objectParameter = registerObjectMethod.new Parameter(Object.class, "object");
		registerObjectMethod.addParameter(objectParameter);
		registerObjectMethod.getBody().append("this.impl.register(object)");
		
		Method registerObjectsMethod = new Method(Visibility.PUBLIC,void.class,"register");
		Parameter objectsParameter = registerObjectsMethod.new Parameter(Object.class, "objects");
		objectParameter.setArray(true);
		registerObjectsMethod.addParameter(objectsParameter);
		registerObjectsMethod.getBody().append("this.impl.register(objects)");
		
		Method lookupMethod = new Method(Visibility.PUBLIC,Object.class,"lookup");
		lookupMethod.addParameter(lookupMethod.new Parameter(Class.class, "type"));
		lookupMethod.getBody().append("return this.impl.lookup(type)");
		
		Method lookupAllMethod = new Method(Visibility.PUBLIC,List.class,"lookupAll");
		lookupAllMethod.addParameter(lookupAllMethod.new Parameter(Class.class, "type"));
		lookupAllMethod.getBody().append("return this.impl.lookupAll(type)");		
		
		
		//fields
		composerHelper.addField(impl);

		
		//methods
		composerHelper.addMethod(contructor);
		composerHelper.addMethod(registerObjectMethod);
		composerHelper.addMethod(registerObjectsMethod);
		composerHelper.addMethod(lookupMethod);
		composerHelper.addMethod(lookupAllMethod);
		
	}

	
	
	public void setType(JClassType type) {
		this.type = type;
	}	
	
}
