/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.reflection;

import java.util.Collection;
import java.util.HashMap;

import org.apache.commons.lang.ClassUtils;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.observable.event.IObservableHandler;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.observable.event.MethodCalledEvent;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.observable.event.SetterCalledEvent;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.reflection.IHasReflectionHandler;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.reflection.IHasReflectionProxy;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.reflection.SetFieldValueCalledEvent;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.reflection.annotation.Reflection;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.SetterHandler;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.ComposerHelper;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.Field;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.JClassTypeHelper;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.JTypeHelper;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.Method;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.Visibility;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.Method.Parameter;
import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JField;
import com.google.gwt.event.shared.HandlerManager;

public class ReflectionProxyGenerator extends Generator{

	private JClassType type;
	
	private ComposerHelper composerHelper;
	
	private String simpleClassName;
	
	private Reflection reflectionAnnotation;
	
	@Override
	public String generate(TreeLogger logger, GeneratorContext context,
			String typeName) throws UnableToCompleteException {
		
		simpleClassName 		= type.getSimpleSourceName() + "_ReflectionProxy";
		
		composerHelper		   	= new ComposerHelper(context, logger, type.getPackage().getName(), simpleClassName);
		
		composerHelper.setSuperClass(typeName);
		
		reflectionAnnotation	= type.getAnnotation(Reflection.class);
		
		composerHelper.addInterface(IHasReflectionProxy.class);
		
		createConstructor();
		
		createGetFieldsMethod();
		
		createSetFieldValue(Object.class);
		createSetFieldValue(Integer.class);
		createSetFieldValue(Long.class);
		createSetFieldValue(Float.class);
		createSetFieldValue(Double.class);
		createSetFieldValue(Boolean.class);
		
		createCopyMethod();
		
		overrideAllFields();
		
		overrideAllSetters();
		
		overrideAllGetters();
		
		createAddHandlerMethod();
		
		createGetRealTypeMethod();
		
		composerHelper.commit();
		
		return composerHelper.getCreatedClassName();
	}
	
	private void createGetRealTypeMethod(){
		
		Method m = new Method(Visibility.PUBLIC,Class.class,"getRealType");
		
		m.getBody().append("return "+type.getQualifiedSourceName()+".class");
		
		composerHelper.addMethod(m);
	}
	
	private void createAddHandlerMethod(){
		
		Method addHandlerMethod = new Method(Visibility.PUBLIC,void.class,"addHandler");
		addHandlerMethod.isOverride(true);
		addHandlerMethod.addParameter(addHandlerMethod.new Parameter(IHasReflectionHandler.class, "handler"));
		
		composerHelper.addImport(SetFieldValueCalledEvent.class);
		
		addHandlerMethod.getBody().append(handlerManagerField.getName()+".addHandler(SetFieldValueCalledEvent.TYPE,handler)");
		
		composerHelper.addMethod(addHandlerMethod);
	}
	
	private Field fieldsField;
	
	private boolean ignore(JField field){
		
		if (reflectionAnnotation!=null){
			
			for(String fieldName:reflectionAnnotation.skipFields()){
				
				if (fieldName.equals(field.getName())){
					return true;
				}
				
			}
			
		}
		
		return false;
	}
	
	private Field handlerManagerField;
	
	private void createConstructor(){
		
		handlerManagerField = new Field(Visibility.PRIVATE, HandlerManager.class, "handlerManager");
		fieldsField = new Field(Visibility.PRIVATE,HashMap.class,"fields");
		
		composerHelper.addField(fieldsField);
		composerHelper.addField(handlerManagerField);
		
		Method constructor = new Method(Visibility.PUBLIC, simpleClassName);
		
		constructor.getBody().append("super()");
		
		constructor.getBody().instantiate(handlerManagerField,"this");
		constructor.getBody().instantiate(fieldsField);
		
		//populate fields field
		JClassTypeHelper helper = new JClassTypeHelper(type);
		
		for(JField field:helper.getAllFields()){
			

			if (ignore(field)==false){

			Field tmpField      = new Field(Visibility.PRIVATE,JTypeHelper.getClass(field.getType()),field.getName(),field.getType().isParameterized());
			
			Method getter		= tmpField.getGetter(false);
			Method setter		= tmpField.getSetter(false, false);

			//initialize fields
			constructor.getBody().append("this."+field.getName()+"_proxy"+"= super."+getter.getName()+"()");
			
			String fieldVarName = "field"+field.getName();
			
			composerHelper.addImport(com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.Field.class);
			
			constructor.getBody().append("Field "+fieldVarName+" = new Field(\""+field.getName()+"\","+field.getType().getQualifiedSourceName()+".class,"+field.getEnclosingType().getQualifiedSourceName()+".class);");
			
			constructor.getBody().append(String.format(fieldVarName+".setFieldValue(%s())", getter.getName()));
			
			constructor.getBody().append(fieldVarName+".setEnclosingObject(this)");
			
			composerHelper.addImport(SetterHandler.class);

			constructor.getBody().append(fieldVarName+".setSetterHandler(new SetterHandler(){ " +
						"public void setValue(Object value){" +
						setter.getName()+"(("+JTypeHelper.getClass(field.getType()).getCanonicalName()+")value);"+
						"}"+
					"} )");
			
			constructor.getBody().append(String.format("this.fields.put(\"%s\",%s)", field.getName(),fieldVarName));
			
			}
			
		}
		
		
		composerHelper.addMethod(constructor);
		
	}

	private void createGetFieldsMethod(){
		
		composerHelper.addMethod(fieldsField.getGetter(true));
	
	}
	
	private void overrideAllFields(){
		
		JClassTypeHelper helper = new  JClassTypeHelper(type);
		
		for(JField field:helper.getAllFields()){
			
			if (ignore(field)==false){
			
			Field newField = new Field(Visibility.PRIVATE,JTypeHelper.getClass(field.getType()),field.getName()+"_proxy");
			newField.setJtype(field.getType());
			
			composerHelper.addField(newField);
			
			}
			
		}
		
	}
	
	private void overrideAllGetters(){
		
		JClassTypeHelper helper = new  JClassTypeHelper(type);
		
		for(JField field:helper.getAllFields()){
			
			if (ignore(field)==false){
			
			Field f = new Field(Visibility.PRIVATE, JTypeHelper.getClass(field.getType()), field.getName());
			f.setJtype(field.getType());
			
			Method getter = f.getGetter(true,"_proxy");
			
			composerHelper.addMethod(getter);
			
			}
		}
		
		
	}
	
	private void createCopyMethod(){
		
		Method m = new Method(Visibility.PUBLIC,void.class ,"copy");
		m.addParameter(m.new Parameter(IHasReflectionProxy.class, "p"));
		
		composerHelper.addImport(Collection.class);
		//TODO: check field type before assigning value
		m.getBody().append("Collection<Field> fs = (Collection<Field>) this.fields.values()");
		m.getBody().append(
				"for(Field f1:fs){\n" +
					
					"for(Field f2:p.getFields().values()){\n"+

						"if (f1.getName().equals(f2.getName()) ){" +
								
							" f1.setValue(f2.getValue());\n"+
						
						"}"+
					"}\n"+
				
				"}");
		
		composerHelper.addMethod(m);
	}
	
	private void overrideAllSetters(){
		
		JClassTypeHelper helper = new  JClassTypeHelper(type);
		
		for(JField field:helper.getAllFields()) {
			
			if (ignore(field)==false){
			
			Field f = new Field(Visibility.PRIVATE,JTypeHelper.getClass(field.getType()),field.getName(),field.getType().isParameterized());
			f.setJtype(field.getType());
			
			Method setter = f.getSetter(true,false,"_proxy");
			
			setter.getBody().append(String.format("Field field = (Field) getFields().get(\"%s\")",f.getName()));
			setter.getBody().append(String.format("field.setFieldValue(%s)", f.getName()));
			
			composerHelper.addMethod(setter);
			
			}
		}
		
	}
	
	private void createSetFieldValue(Class<?> clazz){
		
		Method setFieldValueMethod = new Method(Visibility.PUBLIC,void.class, "setFieldValue");
		setFieldValueMethod.isOverride(true);
		setFieldValueMethod.addParameter(setFieldValueMethod.new Parameter(String.class, "name"));
		setFieldValueMethod.addParameter(setFieldValueMethod.new Parameter(clazz, "value"));
		
		JClassTypeHelper helper = new  JClassTypeHelper(type);
		
		for(JField field:helper.getAllFields()) {
			
			if (ignore(field)==false){
			
			Field f = new Field(Visibility.PRIVATE,JTypeHelper.getClass(field.getType()),field.getName(),field.getType().isParameterized());
				
				Class<?> fieldType = JTypeHelper.getClass(field.getType());
				
				if (isOfSameNumberType(clazz, fieldType)){
				
					setFieldValueMethod.getBody().append(String.format("if (name.equals(\"%s\")) this.%s = (%s) value", f.getName(),f.getName()+"_proxy",field.getType().getQualifiedSourceName()));
					setFieldValueMethod.getBody().append(String.format("if (name.equals(\"%s\")) this.%s.fireEvent(new %s(%s,%s))", f.getName(),handlerManagerField.getName(),SetFieldValueCalledEvent.class.getCanonicalName(),"name","value"));
				
				}else{
					
					if (fieldType==clazz){
						setFieldValueMethod.getBody().append(String.format("if (name.equals(\"%s\")) this.%s = (%s) value", f.getName(),f.getName()+"_proxy",f.getType().getCanonicalName()));
						setFieldValueMethod.getBody().append(String.format("if (name.equals(\"%s\")) this.%s.fireEvent(new %s(%s,%s))", f.getName(),handlerManagerField.getName(),SetFieldValueCalledEvent.class.getCanonicalName(),"name","value"));
					}
					
					if (clazz==Object.class && isPrimitive(fieldType)==false){
						setFieldValueMethod.getBody().append(String.format("if (name.equals(\"%s\")) this.%s = (%s) value", f.getName(),f.getName()+"_proxy",f.getType().getCanonicalName()));						
						setFieldValueMethod.getBody().append(String.format("if (name.equals(\"%s\")) this.%s.fireEvent(new %s(%s,%s))", f.getName(),handlerManagerField.getName(),SetFieldValueCalledEvent.class.getCanonicalName(),"name","value"));					
					}
					
				}
			
			}
			
		}
		
		composerHelper.addMethod(setFieldValueMethod);
		
	}
	
	private boolean isOfSameNumberType(Class<?> clazz,Class<?> fieldType){
		
		if (isNumberType(clazz) && isNumberType(fieldType)){
			
			if (ClassUtils.wrapperToPrimitive(clazz)!=null){
				clazz = ClassUtils.wrapperToPrimitive(clazz);
			}
			
			if (ClassUtils.wrapperToPrimitive(fieldType)!=null){
				fieldType = ClassUtils.wrapperToPrimitive(fieldType); 
			}
			
			if (clazz==fieldType){
				return true;
			}
			
		}
		
		return false;
	}
	
	private boolean isPrimitive(Class<?> clazz){
		
		boolean isPrimitiveOrWrapped = clazz.isPrimitive() || ClassUtils.wrapperToPrimitive(clazz) != null;
		return isPrimitiveOrWrapped;
	}
	
	private boolean isNumberType(Class<?> type){

		return Number.class.isAssignableFrom(type);
	}
	
	
	public void setType(JClassType type) {
		this.type = type;
	}
	
}
