/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.scope;

import java.util.LinkedHashSet;
import java.util.Set;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder.IHasModelBinder;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelscope.IHasScope;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelscope.IHasScopeProxy;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelscope.ScopeRegistry;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.ComposerHelper;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.Field;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.Method;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.Visibility;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.modelbinder.WatchedModelProxyGenerator;
import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.NotFoundException;
import com.google.gwt.core.ext.typeinfo.TypeOracle;

public class ScopeModelProxyGenerator extends Generator{
	

	private JClassType type;
	private ComposerHelper composerHelper;
	private String simpleClassName;

	private Field scopeField;
	private Field childrenField;
	
	public void setType(JClassType type) {
		this.type = type;
	}
	
	@Override
	public String generate(TreeLogger logger, GeneratorContext context,
			String typeName) throws UnableToCompleteException {
		
			
			String superClassName = typeName;



			simpleClassName 		= type.getSimpleSourceName() + "_ScopeModelProxy";

			
			composerHelper = new ComposerHelper(context, logger, type.getPackage().getName(), simpleClassName);
			
			
			composerHelper.setSuperClass(superClassName);
			composerHelper.addInterface(IHasScopeProxy.class);
			
			createFields();
			
			createConstructor();
			
			createMethods();
			
			
			composerHelper.commit();
			

		
		
		
		return composerHelper.getCreatedClassName();
	}
	
	private void createFields(){
		
		this.scopeField 	= new Field(Visibility.PRIVATE,String.class,"scope");
		Field parentField 	= new Field(Visibility.PRIVATE,IHasScope.class,"parent");
		this.childrenField = new Field(Visibility.PRIVATE,Set.class,"children");
		
		composerHelper.addField(scopeField);
		composerHelper.addField(parentField);
		composerHelper.addField(childrenField);
		
		Method scopeGetter 		= scopeField.getGetter(true);
		Method parentGetter 	= parentField.getGetter(true);
		Method parentSetter 	= parentField.getSetter(true,false);
		Method childrenGetter 	= childrenField.getGetter(true);
		//childrenGetter.addReturnTypeParameter(IHasScope.class);
		
		composerHelper.addMethod(scopeGetter);
		composerHelper.addMethod(parentGetter);
		composerHelper.addMethod(parentSetter);
		composerHelper.addMethod(childrenGetter);
		
	}
	
	private void createConstructor(){
		
		composerHelper.addImport(LinkedHashSet.class);
		composerHelper.addImport(IHasScope.class);
		composerHelper.addImport(IHasScopeProxy.class);
		
		Method constructor = new Method(Visibility.PUBLIC,simpleClassName);
		constructor.getBody().append("super()");
		constructor.getBody().append(this.childrenField.getName()+"= new LinkedHashSet<IHasScope>()");

		
		composerHelper.addMethod(constructor);
		
	}
	
	private void createMethods(){
		
		//attach
		Method attachMethod = new Method(Visibility.PUBLIC,void.class,"attachToScope");
		attachMethod.isOverride(true);
		attachMethod.addParameter(attachMethod.new Parameter(String.class, "scopeId"));
		
		composerHelper.addImport(ScopeRegistry.class);
		
		attachMethod.getBody().append("ScopeRegistry.getInstance().registerModel(scopeId,this)");
		attachMethod.getBody().append("this."+scopeField.getName()+"=scopeId");
		
		//detach
		Method detachMethod = new Method(Visibility.PUBLIC,void.class,"detachFromScope");
		detachMethod.isOverride(true);
		
		detachMethod.getBody().append("ScopeRegistry.getInstance().unregisterModel(this."+scopeField.getName()+",this)");
		
		//addChild
		Method addChildMethod = new Method(Visibility.PUBLIC,void.class,"addChild");
		addChildMethod.addParameter(addChildMethod.new Parameter(IHasScope.class, "child"));
		addChildMethod.isOverride(true);
		addChildMethod.getBody().append("this."+childrenField.getName()+".add(child)");
		addChildMethod.getBody().append("" +
				"if (child instanceof IHasScopeProxy){" +
				"IHasScopeProxy proxy = (IHasScopeProxy) child;" +
				"proxy.setParent(this);" +
				"}");
		//getRealType
		Method getRealTypeMethod = new Method(Visibility.PUBLIC,Class.class,"getRealType");
		getRealTypeMethod.isOverride(true);
		
		getRealTypeMethod.getBody().append("return "+type.getQualifiedSourceName()+".class");
		
		composerHelper.addMethod(attachMethod);
		composerHelper.addMethod(detachMethod);
		composerHelper.addMethod(addChildMethod);
		composerHelper.addMethod(getRealTypeMethod);
		
	}
	
	
}
