/**
 * webeditor-api - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.api.core;




import com.ebmwebsourcing.geasytools.webeditor.api.components.events.IComponentHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.core.events.IEditorEventBus;
import com.ebmwebsourcing.geasytools.webeditor.api.core.events.IEditorHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.core.manager.IComponentManager;
import com.ebmwebsourcing.geasytools.webeditor.api.core.manager.IContentManager;
import com.ebmwebsourcing.geasytools.webeditor.api.core.manager.ICoreManager;
import com.ebmwebsourcing.geasytools.webeditor.api.core.manager.IDownloadManager;
import com.ebmwebsourcing.geasytools.webeditor.api.core.manager.IMainMenuManager;
import com.ebmwebsourcing.geasytools.webeditor.api.core.manager.IPluginManager;
import com.ebmwebsourcing.geasytools.webeditor.api.core.manager.IPresenterManager;
import com.ebmwebsourcing.geasytools.webeditor.api.core.manager.IProjectManager;
import com.ebmwebsourcing.geasytools.webeditor.api.core.manager.IToolbarManager;
import com.ebmwebsourcing.geasytools.webeditor.api.layout.events.ILayoutHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.service.IServiceFactory;
import com.google.gwt.event.shared.HasHandlers;

public interface IEditorFrontController extends HasHandlers {

	IEditorView getView();
	
	IEditorRegistry getRegistry();
	
	void addEditorHandler(IEditorHandler handler);
	
	void addComponentHandler(IComponentHandler handler);
	
	void addLayoutHandler(ILayoutHandler handler);
	
	IComponentDispatcher getComponentDispatcher();
	
	ICoreManager getCoreManager();
	
	IPresenterManager getPresenterManager();
	
	IPluginManager getPluginManager();
	
	IMainMenuManager getMainMenuManager();
	
	IProjectManager getProjectManager();
	
	IContentManager getContentManager();
	
	IComponentManager getComponentManager();

	IDownloadManager getDownloadManager();
	
	IToolbarManager getToolbarManager();
	
	IServiceFactory getServiceFactory();

	IEditorEventBus getEventBus();
}
