/**
 * webeditor-impl - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.impl.client.core.handler.manager.mainmenu;

import com.ebmwebsourcing.geasytools.webeditor.api.components.menu.IMainMenuComponent;
import com.ebmwebsourcing.geasytools.webeditor.api.core.handler.manager.mainmenu.IDefaultContentPanelPlaceHolderHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.core.manager.IMainMenuManager;
import com.ebmwebsourcing.geasytools.webeditor.api.layout.events.IAddComponentEvent;
import com.ebmwebsourcing.geasytools.webeditor.api.layout.events.IPanelChangeEvent;

public class DefaultContentPanelPlaceHolderHandler implements IDefaultContentPanelPlaceHolderHandler{
	
	private IMainMenuManager mainMenuManager;
	
	public DefaultContentPanelPlaceHolderHandler(IMainMenuManager mainMenuManager) {
		this.mainMenuManager = mainMenuManager;
	}
	
	@Override
	public IMainMenuManager getMainMenuManager() {
		return mainMenuManager;
	}

	@Override
	public void onPanelChange(IPanelChangeEvent event) {
		
		if (event.getSelectedPanel().getProjectInstance()!=null){
			enableMenuItems(true);
		}else{
			enableMenuItems(false);
		}
		
	}

	@Override
	public void onAddComponent(IAddComponentEvent event) {
		// TODO Auto-generated method stub
		
	}
	
	private void enableMenuItems(boolean b){
		
		IMainMenuComponent mainMenuComponent = mainMenuManager.getFrontController().getView().getMainMenuComponent();
		
		mainMenuComponent.getSaveItem().setEnable(b);
		mainMenuComponent.getExportItem().setEnable(b);
		
		mainMenuComponent.getValidateProjectItem().setEnable(b);
		mainMenuComponent.getEditProjectItem().setEnable(b);
		
	}

}
