/**
 * webeditor-impl - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.impl.client.core.manager;

import com.ebmwebsourcing.geasytools.webeditor.api.core.IEditorFrontController;
import com.ebmwebsourcing.geasytools.webeditor.api.core.events.IConfirmDialogEvent;
import com.ebmwebsourcing.geasytools.webeditor.api.core.events.IDisableLoadingStateEvent;
import com.ebmwebsourcing.geasytools.webeditor.api.core.events.IEditorErrorEvent;
import com.ebmwebsourcing.geasytools.webeditor.api.core.events.IEditorHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.core.events.IEditorLoadEvent;
import com.ebmwebsourcing.geasytools.webeditor.api.core.events.IEnableLoadingStateEvent;
import com.ebmwebsourcing.geasytools.webeditor.api.core.manager.ICoreManager;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.core.events.DisableLoadingStateEvent;

public class CoreManager extends AbstractManager implements ICoreManager{
	

	
	public CoreManager(IEditorFrontController controller) {
		super(controller);

	}

	@Override
	public void bindEvents() {
		
		getEventBus().addEditorHandler(new IEditorHandler() {
			
			@Override
			public void onLoad(IEditorLoadEvent event) {
				
				
				
			}
			
			@Override
			public void onLayoutChange() {
			
				
			}
			
			@Override
			public void onError(IEditorErrorEvent event) {

				//disable loading state
				getEventBus().fireEvent(new DisableLoadingStateEvent());

				
				//display error message
				getFrontController().getView().displayError(event.getTitle(), event.getMessage(), event.getLevel());
				
			
			}
			
			@Override
			public void onEnableLoadingState(IEnableLoadingStateEvent event) {
				
				getFrontController().getView().enableLoadingState(event.getMessage());
				
			}
			
			@Override
			public void onDisableLoadingState(IDisableLoadingStateEvent event) {
				
				getFrontController().getView().disableLoadingState();
				
			}
			
			@Override
			public void onClose() {
				
				
			}

			@Override
			public void onConfirmDialog(IConfirmDialogEvent event) {
				
				getFrontController().getView().displayConfirmDialog(event.getTitle(), event.getMessage(), event.getConfirmationCallback());
				
			}
		});
		
	}

}
