/**
 * webeditor-impl - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.impl.client.component.menu;

import com.ebmwebsourcing.geasytools.webeditor.api.components.menu.IMenu;
import com.ebmwebsourcing.geasytools.webeditor.api.components.menu.IMenuButtonItem;
import com.ebmwebsourcing.geasytools.webeditor.api.components.menu.IMenuItemAction;
import com.ebmwebsourcing.geasytools.webeditor.api.components.menu.IMenuItemClickHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.components.menu.IMenuItemGroup;

public class MenuComponentButton implements IMenuButtonItem{
	
	private IMenu menu;
	private String text;
	private IMenuItemAction action;
	private IMenuItemGroup group;
	private IMenuItemClickHandler clickHandler;
	private boolean enabled;
	
	public MenuComponentButton() {

	}

	public MenuComponentButton(String text) {
		this.text = text;
	}
	
	@Override
	public IMenu getMenu() {
		return menu;
	}

	@Override
	public String getText() {
		return text;
	}

	@Override
	public void setMenu(IMenu menu) {
		this.menu = menu;
	}

	@Override
	public void setText(String text) {
		this.text = text;
	}

	@Override
	public IMenuItemAction getAction() {
		return action;
	}

	@Override
	public IMenuItemGroup getGroup() {
		return group;
	}

	@Override
	public void setAction(IMenuItemAction action) {
		this.action = action;
	}

	@Override
	public void setGroup(IMenuItemGroup group) {
		this.group = group;
	}

	@Override
	public IMenuItemClickHandler getClickHandler() {
		return clickHandler;
	}

	@Override
	public void setClickHandler(IMenuItemClickHandler clickHandler) {
		this.clickHandler = clickHandler;
	}

	@Override
	public void setEnabled(boolean b) {
		this.enabled  =  b;
	}

	@Override
	public boolean isEnabled() {
		return this.enabled;
	}
	
	

}
