/**
 * Petals View.
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * PetalsViewFault.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.petalsview.ws;

import javax.xml.ws.WebFault;

/**
 * @author ofabre - eBM Websourcing
 * 
 */
@WebFault(name = "PetalsViewFault", targetNamespace = "http://petalsview.ebmwebsourcing.com", faultBean = "com.ebmwebsourcing.petalsview.ws.PetalsViewFault")
public class PetalsViewFault extends Exception {

    /**
     * 
     */
    private static final long serialVersionUID = -6901029685186349925L;

    private String message;

    private PetalsViewFaultDetail faultDetail;

    public PetalsViewFault(String message, PetalsViewFaultDetail faultDetail) {
        super();
        this.message = message;
        this.faultDetail = faultDetail;
    }

    public PetalsViewFault(String message, Throwable t) {
        super();
        this.message = message;
        PetalsViewFaultDetail faultDetail = new PetalsViewFaultDetail();
        faultDetail.setFaultStack(getStackTrace(t));
        this.faultDetail = faultDetail;
    }

    public PetalsViewFault(String message) {
        super();
        this.message = message;
    }

    @Override
    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public PetalsViewFaultDetail getFaultDetail() {
        return faultDetail;
    }

    public void setFaultDetail(PetalsViewFaultDetail faultDetail) {
        this.faultDetail = faultDetail;
    }

    public String getStackTrace(Throwable t) {
        java.io.StringWriter out = new java.io.StringWriter();
        t.printStackTrace(new java.io.PrintWriter(out));
        String stackTrace = out.toString();

        return stackTrace;
    }

}
