/**
 * Petals View - Functional Supervision.
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * FlowManagerImpl.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.petalsview.ws.flow;

import javax.annotation.Resource;
import javax.jws.WebService;

import com.ebmwebsourcing.petalsview.service.flow.FlowException;
import com.ebmwebsourcing.petalsview.ws.PetalsViewFault;

/**
 * @author strino
 *
 */
@WebService(endpointInterface = "com.ebmwebsourcing.petalsview.ws.flow.FlowManager")
public class FlowManagerImpl implements FlowManager {

	@Resource
	private com.ebmwebsourcing.petalsview.service.flow.FlowManager flowManager;

	/**
	 * @param type
	 * @throws FlowException
	 * @see com.ebmwebsourcing.petalsview.service.flow.FlowManager#removeOldFlow(int)
	 */
	public void removeOldFlow(int type) throws PetalsViewFault {
		try {
			flowManager.removeOldFlow(type);
		} catch (FlowException e) {
			throw new PetalsViewFault("Can't remove old flow for type: "+type, e);
		}
	}

	/**
	 * @see com.ebmwebsourcing.petalsview.service.flow.FlowManager#getAllFlowReferentialType()
	 */
	public int[] getAllFlowReferentialType() {
		
			int[] allTypes = flowManager.getAllFlowReferentialType();
		return allTypes;
	}
	
	
	
	

}
