/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * ServiceManagerImpl.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.petalsview.ws.administration;

import javax.annotation.Resource;
import javax.jws.WebService;

import com.ebmwebsourcing.petalsview.service.admin.DatabaseManager;
import com.ebmwebsourcing.petalsview.ws.PetalsViewFault;
import com.ebmwebsourcing.webcommons.user.api.service.RoleGroupManager;
import com.ebmwebsourcing.webcommons.user.api.service.RoleManager;
import com.ebmwebsourcing.webcommons.user.api.service.UserManager;

/**
 * @author ofabre - eBM Websourcing
 * 
 */
@WebService(endpointInterface = "com.ebmwebsourcing.petalsview.ws.administration.DatabaseAdmin")
public class DatabaseAdminImpl implements DatabaseAdmin {

    @Resource
    private DatabaseManager databaseManager;

    @Resource
    private UserManager userManager;

    @Resource
    private RoleManager roleManager;

    @Resource
    private RoleGroupManager roleGroupManager;

    public void initDatabase() throws PetalsViewFault {
        try {
            roleManager.init();
            roleGroupManager.init();
            userManager.init();
        } catch (Exception e) {
            throw new PetalsViewFault("Can't init database.", e);
        }
    }

    public void recreateDatabase() {
        databaseManager.recreateDatabase();
    }

    public void setDatabaseManager(DatabaseManager databaseManager) {
        this.databaseManager = databaseManager;
    }
}
