/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.petalsview.util;

import com.ebmwebsourcing.petalsview.service.dataexporter.Exporter;
import com.ebmwebsourcing.petalsview.service.dataloader.Dataloader;
import com.ebmwebsourcing.petalsview.service.flow.FlowManager;
import com.ebmwebsourcing.petalsview.service.flow.FlowStepManager;
import com.ebmwebsourcing.petalsview.service.flowref.FlowRefManager;
import com.ebmwebsourcing.petalsview.service.flowref.FlowStepRefManager;
import com.ebmwebsourcing.webcommons.user.api.service.RoleGroupManager;
import com.ebmwebsourcing.webcommons.user.api.service.RoleManager;
import com.ebmwebsourcing.webcommons.user.api.service.UserManager;
import com.ebmwebsourcing.webcommons.util.SpringUtil;
import javax.servlet.ServletContext;
import org.ow2.opensuit.core.session.OpenSuitSession;
import org.springframework.context.ApplicationContext;

public class PetalsViewServiceFactory {
    private final ApplicationContext springContext;
    private static PetalsViewServiceFactory instance;

    public static PetalsViewServiceFactory getInstance() {
        if (instance == null) {
            instance = new PetalsViewServiceFactory();
        }
        return instance;
    }

    private PetalsViewServiceFactory() {
        ServletContext servletContext = OpenSuitSession.getCurrentRequest().getSession().getServletContext();
        this.springContext = SpringUtil.getWebApplicationContext((ServletContext)servletContext);
    }

    public FlowManager getFlowManager() {
        return (FlowManager)this.springContext.getBean("flowManager");
    }

    public FlowRefManager getFlowRefManager() {
        return (FlowRefManager)this.springContext.getBean("flowRefManager");
    }

    public UserManager getUserManager() {
        return (UserManager)this.springContext.getBean("userManager");
    }

    public RoleGroupManager getRoleGroupManager() {
        return (RoleGroupManager)this.springContext.getBean("roleGroupManager");
    }

    public RoleManager getRoleManager() {
        return (RoleManager)this.springContext.getBean("roleManager");
    }

    public Dataloader getDataLoader() {
        return (Dataloader)this.springContext.getBean("dataloader");
    }

    public Exporter getExporter() {
        return (Exporter)this.springContext.getBean("dataexporter");
    }

    public FlowStepManager getFlowStepManager() {
        return (FlowStepManager)this.springContext.getBean("flowStepManager");
    }

    public FlowStepRefManager getFlowStepRefManager() {
        return (FlowStepRefManager)this.springContext.getBean("flowStepRefManager");
    }
}

