/**
 * bpmn-plugins - Geasy BPMN Editor Plugins - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.client.plugin.bpmn;

import com.ebmwebsourcing.petalsbpm.definitionseditor.imports.IImportType;

public enum ExternalImportType implements IImportType{
	
	UPLOAD_WSDL1_1("Upload WSDL 1.1 file"),
	UPLOAD_BPMN2_0("Upload BPMN 2.0 file"),
	UPLOAD_XSD("Upload XSD file"),
	PETALS_MASTER("Import a WSDL via Petals Master");
	
	private String label;
	
	private ExternalImportType(String label) {
		this.label = label;
	}
	
	@Override
	public String getLabel() {
		return label;
	}

}
