/**
 * bpmn-plugins - Geasy BPMN Editor Plugins - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.descriptive;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.BPMNExportFormat;
import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.BPMNMetaDataFormat;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceFormat;
import com.ebmwebsourcing.webeditor.impl.domain.project.ProjectType;

public abstract class DescriptiveBPMNProjectType extends ProjectType {

    public DescriptiveBPMNProjectType(String id, String name, String description) {
        super(id, name, description);
        setWriterQname("com.ebmwebsourcing.petalsbpm.server.plugin.bpmn.descriptive.DescriptiveBPMNProjectInstanceWriter");

        List<IProjectInstanceFormat> exportFormats = new ArrayList<IProjectInstanceFormat>();
        exportFormats.add(BPMNExportFormat.BPMN);
        exportFormats.add(BPMNExportFormat.XPDL);
        setExportFormats(exportFormats);

        List<IProjectInstanceFormat> importFormats = new ArrayList<IProjectInstanceFormat>();
        importFormats.add(BPMNExportFormat.BPMN);
        importFormats.add(BPMNExportFormat.XPDL);
        setImportFormats(importFormats);

        setFormat(BPMNExportFormat.BPMN);

        this.addMetaDataLoaderQname(BPMNMetaDataFormat.BPMN2_0, "com.ebmwebsourcing.petalsbpm.server.plugin.bpmn.descriptive.BPMNImportLoader");
    }

}
