/**
 * bpmn-plugins - Geasy BPMN Editor Plugins - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.server.plugin.bpmn.executable;

import java.io.File;
import java.net.URL;

import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.BPELGenerator;
import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.BPMNExportFormat;
import com.ebmwebsourcing.petalsbpm.server.plugin.bpmn.BPMNFileHelper;
import com.ebmwebsourcing.petalsbpm.server.plugin.bpmn.descriptive.DescriptiveBPMNProjectInstanceWriter;
import com.ebmwebsourcing.petalsbpm.utils.server.FileHelper;
import com.ebmwebsourcing.petalsbpm.utils.server.ZipHelper;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstance;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceFormat;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceMetaData;
import com.ebmwebsourcing.webeditor.impl.domain.exception.ServiceException;

public class ExecutableBPMNProjectInstanceWriter extends DescriptiveBPMNProjectInstanceWriter{

    
    @Override
    public File writeProjectFile(IProjectInstance projectInstance, File projectOutputDirectory) throws ServiceException {
        return super.writeProjectFile(projectInstance, projectOutputDirectory);
    }
    
	@Override
	public File writeProjectFile(File projectFile, IProjectInstanceMetaData exportData,
			IProjectInstanceFormat format, File directory) throws ServiceException {
		try{
			switch((BPMNExportFormat)format){
			case BPMN:
				return projectFile;

			case BPEL:
				return getBPELZipFromBPMN(projectFile,exportData,directory);
				
			default:
				throw new ServiceException("This format ("+format+") is not supported.");
			}
		}catch(Exception e){
			throw new ServiceException("The project file could not be written : "+e.getMessage(),e); 
		}
	}
	
	
	private File getBPELZipFromBPMN(File projectInstanceFile, IProjectInstanceMetaData exportData, File directory) throws Exception{
	    FileHelper.cleanDirectory(directory);
	    
	    //first retrieve the bpmn defintions form the given project instance file
		if(ZipHelper.getInstance().isZipFile(projectInstanceFile)) {
		    ZipHelper.getInstance().unzipFile(projectInstanceFile,directory);
		}
		else {
		   FileHelper.copyFile(projectInstanceFile, directory);
		}
		
		File bpmnFile = BPMNFileHelper.getBPMNFileInFolder(directory);
		URL url	= bpmnFile.toURI().toURL();
		Definitions defs = new XmlContextFactory().newContext().createReader().readDocument(url, Definitions.class);
		
		//get or create a temp dir and generate bpel and wsdl files in it
		String bpelZipPath = directory.getAbsolutePath()+File.separator+"zip";
		File bpelZipDir = new File(bpelZipPath);
		if(!bpelZipDir.exists()) {
		    bpelZipDir.mkdir();
		}
		FileHelper.cleanDirectory(bpelZipDir);
		
		new BPELGenerator().generate(defs, bpelZipPath);
		
		//make a zip out of this temporary directory
		return ZipHelper.getInstance().createZipFromFolder(bpelZipPath, directory.getAbsolutePath()+File.separator+"BPEL"+defs.getId()+".zip");
	}
	
	
    @Override
	public File writeProjectFile(File projectFile, IProjectInstanceFormat format, File directory) throws ServiceException {
		try{
			switch((BPMNExportFormat)format){
			case BPMN:
				return  projectFile;

			case BPEL:
			    return getBPELZipFromBPMN(projectFile,null,directory);
				
			default:
				throw new ServiceException("This format ("+format+") is not supported.");
			}
		}catch(Exception e){
		    throw new ServiceException("The project file could not be written : "+e.getMessage(),e); 
		}
	}

}
