/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.petalsbpm.server.plugin.bpmn;

import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.infrastructure.IDefinitionsBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.DefinitionsBean;
import com.ebmwebsourcing.petalsbpm.business.domain.di.api.IBPMNDiagram;
import com.ebmwebsourcing.petalsbpm.business.domain.di.impl.BPMNDiagram;
import com.ebmwebsourcing.petalsbpm.business.domain.di.impl.mock.BPMNDIMockDB;
import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.BPMNExportFormat;
import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.BPMNProjectInstance;
import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.descriptive.DescriptiveBPMNProjectInstance;
import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.descriptive.DescriptiveBPMNProjectType;
import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.descriptive.process.DescriptiveBPMNPrivateProcessProjectType;
import com.ebmwebsourcing.petalsbpm.server.plugin.bpmn.descriptive.DescriptiveBPMNProjectInstanceWriter;
import com.ebmwebsourcing.petalsbpm.server.plugin.bpmn.descriptive.process.DescriptiveBPMNWorkflowProjectInstanceLoader;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstance;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceFormat;
import com.ebmwebsourcing.webeditor.impl.domain.exception.ServiceException;
import com.ebmwebsourcing.webeditor.server.impl.service.common.AbstractCommonServiceTest;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;

public class BPMNProjectInstanceTest
extends AbstractCommonServiceTest {
    private String testPath;
    private String tempPath;

    @Before
    public void init() throws IOException {
        this.testPath = this.projectsDir + File.separator + "test";
        File f1 = new File(this.testPath);
        if (!f1.exists()) {
            f1.mkdirs();
        }
        this.tempPath = this.projectsDir + File.separator + "temp" + File.separator;
        File f2 = new File(this.tempPath);
        if (!f2.exists()) {
            f2.mkdirs();
        }
    }

    @Test
    public void testBPMN() throws ServiceException {
        for (BPMNProjectInstance instance : this.getInstances()) {
            File zipFile = new DescriptiveBPMNProjectInstanceWriter().writeProjectFile((IProjectInstance)instance, new File(this.testPath));
            System.out.println(zipFile);
            ArrayList<File> l = new ArrayList<File>();
            l.add(zipFile);
            List li = new DescriptiveBPMNWorkflowProjectInstanceLoader().getProjectInstances(l, (IProjectInstanceFormat)BPMNExportFormat.BPMN);
            Assert.assertEquals((int)1, (int)li.size());
            Assert.assertTrue((boolean)(li.get(0) instanceof BPMNProjectInstance));
            zipFile = new DescriptiveBPMNProjectInstanceWriter().writeProjectFile(zipFile, (IProjectInstanceFormat)BPMNExportFormat.BPMN, new File(this.tempPath));
            System.out.println(zipFile);
            l = new ArrayList();
            l.add(zipFile);
            li = new DescriptiveBPMNWorkflowProjectInstanceLoader().getProjectInstances(l, (IProjectInstanceFormat)BPMNExportFormat.BPMN);
            Assert.assertEquals((int)1, (int)li.size());
            Assert.assertTrue((boolean)(li.get(0) instanceof BPMNProjectInstance));
        }
    }

    @Test
    public void testXPDL() throws ServiceException {
        for (BPMNProjectInstance instance : this.getInstances()) {
            File zipFile = new DescriptiveBPMNProjectInstanceWriter().writeProjectFile((IProjectInstance)instance, new File(this.testPath));
            System.out.println(zipFile);
            File xpdlFile = new DescriptiveBPMNProjectInstanceWriter().writeProjectFile(zipFile, (IProjectInstanceFormat)BPMNExportFormat.XPDL, new File(this.tempPath));
            ArrayList<File> l = new ArrayList<File>();
            l.add(xpdlFile);
            List li = new DescriptiveBPMNWorkflowProjectInstanceLoader().getProjectInstances(l, (IProjectInstanceFormat)BPMNExportFormat.XPDL);
            Assert.assertEquals((int)1, (int)li.size());
            Assert.assertTrue((boolean)(li.get(0) instanceof BPMNProjectInstance));
        }
    }

    @Test
    public void testBPEL() throws Exception {
        for (BPMNProjectInstance instance : this.getInstances()) {
            File zipFile = new DescriptiveBPMNProjectInstanceWriter().writeProjectFile((IProjectInstance)instance, new File(this.testPath));
            try {
                new DescriptiveBPMNProjectInstanceWriter().writeProjectFile(zipFile, instance.getExportData(), (IProjectInstanceFormat)BPMNExportFormat.BPEL, new File(this.tempPath));
            }
            catch (ServiceException se) {
                continue;
            }
            Assert.fail((String)"Should have failed.");
        }
    }

    private List<BPMNProjectInstance> getInstances() {
        ArrayList<BPMNProjectInstance> res = new ArrayList<BPMNProjectInstance>();
        BPMNDiagram diagram = BPMNDIMockDB.getPrivateProcessDI1();
        DefinitionsBean defsBean = BPMNDIMockDB.getPrivateProcessDefsDI1();
        DescriptiveBPMNProjectInstance i = new DescriptiveBPMNProjectInstance((DescriptiveBPMNProjectType)new DescriptiveBPMNPrivateProcessProjectType());
        i.setBpmndiagram((IBPMNDiagram)diagram);
        i.setDefinitions((IDefinitionsBean)defsBean);
        i.setName(defsBean.getId());
        res.add((BPMNProjectInstance)i);
        diagram = BPMNDIMockDB.getDI1();
        defsBean = BPMNDIMockDB.getDefsDI1();
        i = new DescriptiveBPMNProjectInstance((DescriptiveBPMNProjectType)new DescriptiveBPMNPrivateProcessProjectType());
        i.setBpmndiagram((IBPMNDiagram)diagram);
        i.setDefinitions((IDefinitionsBean)defsBean);
        i.setName(defsBean.getId());
        res.add((BPMNProjectInstance)i);
        diagram = BPMNDIMockDB.getDI2();
        defsBean = BPMNDIMockDB.getDefsDI2();
        i = new DescriptiveBPMNProjectInstance((DescriptiveBPMNProjectType)new DescriptiveBPMNPrivateProcessProjectType());
        i.setBpmndiagram((IBPMNDiagram)diagram);
        i.setDefinitions((IDefinitionsBean)defsBean);
        i.setName(defsBean.getId());
        res.add((BPMNProjectInstance)i);
        return res;
    }
}

