/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.petalsbpm.server.plugin.bpmn;

import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IItemDefinitionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IMessageBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IParticipantBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.infrastructure.IDefinitionsBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.infrastructure.IImportBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.infrastructure.INamespaceDeclaration;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.activity.ITaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.service.IInterfaceBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.service.IOperationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.DefinitionsBeanVisitor;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.ItemDefinitionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.MessageBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.DefinitionsBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.NamespaceDeclaration;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.xsd.XSDImportBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.activity.ReceiveTaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.activity.SendTaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.activity.ServiceTaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.service.InterfaceBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.service.OperationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.di.api.IBPMNDiagram;
import com.ebmwebsourcing.petalsbpm.business.domain.di.impl.BPMNDiagram;
import com.ebmwebsourcing.petalsbpm.business.domain.di.impl.mock.BPMNDIMockDB;
import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.BPMNExportFormat;
import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.BPMNProjectInstance;
import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.executable.ExecutableBPMNProjectInstance;
import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.executable.ExecutableBPMNProjectType;
import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.executable.process.ExecutableBPMNPrivateProcessProjectType;
import com.ebmwebsourcing.petalsbpm.server.plugin.bpmn.executable.ExecutableBPMNProjectInstanceWriter;
import com.ebmwebsourcing.petalsbpm.server.plugin.bpmn.executable.process.ExecutableBPMNWorkflowProjectInstanceLoader;
import com.ebmwebsourcing.petalsbpm.utils.server.FileHelper;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstance;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceFormat;
import com.ebmwebsourcing.webeditor.impl.domain.exception.ServiceException;
import com.ebmwebsourcing.webeditor.server.impl.service.common.AbstractCommonServiceTest;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExecutableBPMNProjectInstanceTest
extends AbstractCommonServiceTest {
    private static final String TNS = "http://www.A.com";
    private static final String eltName = "myString";
    private String testPath;
    private String tempPath;

    @Before
    public void init() throws IOException {
        this.testPath = this.projectsDir + File.separator + "testBPEL";
        File f1 = new File(this.testPath);
        if (!f1.exists()) {
            f1.mkdirs();
        }
        this.tempPath = this.projectsDir + File.separator + "tempBPEL";
        File f2 = new File(this.tempPath);
        if (!f2.exists()) {
            f2.mkdirs();
        }
    }

    @Test
    public void testBPMN() throws Exception {
        File zipFile = new ExecutableBPMNProjectInstanceWriter().writeProjectFile((IProjectInstance)this.getInstance(), new File(this.testPath));
        System.out.println(zipFile);
        ArrayList<File> l = new ArrayList<File>();
        l.add(zipFile);
        List li = new ExecutableBPMNWorkflowProjectInstanceLoader().getProjectInstances(l, (IProjectInstanceFormat)BPMNExportFormat.BPMN);
        Assert.assertEquals((int)1, (int)li.size());
        Assert.assertTrue((boolean)(li.get(0) instanceof BPMNProjectInstance));
        zipFile = new ExecutableBPMNProjectInstanceWriter().writeProjectFile(zipFile, (IProjectInstanceFormat)BPMNExportFormat.BPMN, new File(this.tempPath));
        System.out.println(zipFile);
        l = new ArrayList();
        l.add(zipFile);
        li = new ExecutableBPMNWorkflowProjectInstanceLoader().getProjectInstances(l, (IProjectInstanceFormat)BPMNExportFormat.BPMN);
        Assert.assertEquals((int)1, (int)li.size());
        Assert.assertTrue((boolean)(li.get(0) instanceof BPMNProjectInstance));
    }

    @Test
    public void testBPEL() throws Exception {
        ExecutableBPMNProjectInstance instance = this.getInstance();
        File zipFile = new ExecutableBPMNProjectInstanceWriter().writeProjectFile((IProjectInstance)instance, new File(this.testPath));
        System.out.println(zipFile);
        File tempDir = new File(this.tempPath);
        FileHelper.cleanDirectory((File)tempDir);
        File bpelFile = new ExecutableBPMNProjectInstanceWriter().writeProjectFile(zipFile, instance.getExportData(), (IProjectInstanceFormat)BPMNExportFormat.BPEL, tempDir);
        System.out.println(bpelFile);
    }

    @Test
    public void testXPDL() throws Exception {
        ExecutableBPMNProjectInstance instance = this.getInstance();
        File zipFile = new ExecutableBPMNProjectInstanceWriter().writeProjectFile((IProjectInstance)instance, new File(this.testPath));
        try {
            new ExecutableBPMNProjectInstanceWriter().writeProjectFile(zipFile, instance.getExportData(), (IProjectInstanceFormat)BPMNExportFormat.XPDL, new File(this.tempPath));
        }
        catch (ServiceException se) {
            return;
        }
        Assert.fail((String)"Should have failed.");
    }

    private ExecutableBPMNProjectInstance getInstance() throws Exception {
        BPMNDiagram diagram = BPMNDIMockDB.getDI1();
        DefinitionsBean defsBean = BPMNDIMockDB.getDefsDI1();
        ExecutableBPMNProjectInstance i = new ExecutableBPMNProjectInstance((ExecutableBPMNProjectType)new ExecutableBPMNPrivateProcessProjectType());
        i.setBpmndiagram((IBPMNDiagram)diagram);
        i.setDefinitions((IDefinitionsBean)defsBean);
        i.setName(defsBean.getId());
        ItemDefinitionBean itemDef = new ItemDefinitionBean(this.createUniqueId());
        itemDef.setStructureRef(new QName(TNS, eltName).toString());
        defsBean.addItemDefinition((IItemDefinitionBean)itemDef);
        final MessageBean msg = new MessageBean(this.createUniqueId());
        msg.setName("message");
        msg.setItemDefinition((IItemDefinitionBean)itemDef);
        defsBean.addMessage((IMessageBean)msg);
        final InterfaceBean itf = new InterfaceBean(this.createUniqueId());
        itf.setName("interface");
        defsBean.addInterface((IInterfaceBean)itf);
        final OperationBean op = new OperationBean(this.createUniqueId());
        op.setName("operation");
        op.setMessageIn((IMessageBean)msg);
        itf.addOperation((IOperationBean)op);
        new DefinitionsBeanVisitor((IDefinitionsBean)defsBean){

            public void visitParticipant(IParticipantBean p) {
                p.addInterface((IInterfaceBean)itf);
            }

            public void visitTask(ITaskBean tb) {
                if (tb instanceof ServiceTaskBean) {
                    ((ServiceTaskBean)tb).setOperation((IOperationBean)op);
                } else if (tb instanceof SendTaskBean) {
                    ((SendTaskBean)tb).setOperation((IOperationBean)op);
                    ((SendTaskBean)tb).setMessage((IMessageBean)msg);
                } else if (tb instanceof ReceiveTaskBean) {
                    ((ReceiveTaskBean)tb).setOperation((IOperationBean)op);
                    ((ReceiveTaskBean)tb).setMessage((IMessageBean)msg);
                }
            }
        }.visitDefinitionsByPools();
        NamespaceDeclaration nsd = new NamespaceDeclaration("prefix", TNS);
        defsBean.addImportNSDeclaration((INamespaceDeclaration)nsd);
        XSDImportBean impt = new XSDImportBean((INamespaceDeclaration)nsd, null);
        URL url = Thread.currentThread().getContextClassLoader().getResource("A.xsd");
        impt.setLocation(url.toString());
        defsBean.addImport((IImportBean)impt);
        return i;
    }

    private String createUniqueId() {
        return UUID.randomUUID().toString();
    }
}

