/**
 * bpmn-plugins - Geasy BPMN Editor Plugins - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.client.plugin.bpmn;

import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceFormat;

public enum BPMNExportFormat implements IProjectInstanceFormat{

	XPDL("XPDL 2.1","XML Process Definition Language v2.1"),
	BPMN("BPMN 2.0 ","Business Process Modeling Notation v2.0"),
	BPEL("BPEL 2.0", "Business Process Execution Language v2.0");

	private String name;
	private String description;

	private BPMNExportFormat(){}
	
	private BPMNExportFormat(String name, String desc){
		this.name = name;
		this.description = desc;
	}

	@Override
	public String getDescription() {
		return description;
	}

	@Override
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setDescription(String description) {
		this.description = description;
	}
	
}
