/**
 * bpmn-plugins - Geasy BPMN Editor Plugins - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.server.plugin.bpmn.executable;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.xsd.XSDImportBean;
import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.SchemaProjectInstanceMetaData;
import com.ebmwebsourcing.petalsbpm.server.service.bpmn2.serverToClient.ImportAdapter;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceFormat;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceMetaData;
import com.ebmwebsourcing.webeditor.server.impl.service.webeditor.WebEditorService;
import com.ebmwebsourcing.webeditor.shared.server.api.service.project.IProjectInstanceMetaDataLoader;

public class SchemaLoader implements IProjectInstanceMetaDataLoader{

    private static final String prefix = "schema";
    private static int cpt = 0;
    
    @Override
    public IProjectInstanceMetaData getMetaData(File file, IProjectInstanceFormat format) {
        XmlContext context = new XmlContextFactory().newContext();
        XmlObjectReader reader = context.createReader();
        Schema xsd;
        try {
            xsd = reader.readDocument(new FileInputStream(file), Schema.class);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        } catch (XmlObjectReadException e) {
            e.printStackTrace();
            return null;
        }
        
        String location = WebEditorService.ATTACHMENTS_DIR + File.separator + file.getName();
        
        XSDImportBean impt = ImportAdapter.adaptSchemaImport(getPrefix(), location, xsd);
        SchemaProjectInstanceMetaData metaData = new SchemaProjectInstanceMetaData(impt);

        return metaData;
    }

    private String getPrefix() {
        cpt++;
        return prefix+cpt;
    }
    
}
