/**
 * bpmn-plugins - Geasy BPMN Editor Plugins - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.client.plugin.bpmn;

import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.infrastructure.IDefinitionsBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.mock.IdGenerator;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.DefinitionsBean;
import com.ebmwebsourcing.petalsbpm.business.domain.di.api.IBPMNDiagram;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstance;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectType;
import com.ebmwebsourcing.webeditor.impl.domain.project.ProjectInstance;

public abstract class BPMNProjectInstance extends ProjectInstance implements IProjectInstance {

    private IBPMNDiagram bpmndiagram;

    private IDefinitionsBean definitions;

    protected BPMNProjectInstance() {
        super();
    }

    public BPMNProjectInstance(IProjectType type) {
        this();
        this.definitions = new DefinitionsBean(IdGenerator.createUniqueId());
        this.setType(type);
    }

    public void setDefinitions(IDefinitionsBean definitions) {
        this.definitions = definitions;
    }

    public IDefinitionsBean getDefinitions() {
        return definitions;
    }

    public IBPMNDiagram getBpmndiagram() {
        return bpmndiagram;
    }

    public void setBpmndiagram(IBPMNDiagram bpmndiagram) {
        this.bpmndiagram = bpmndiagram;
    }

}
