/**
 * bpmn-plugins - Geasy BPMN Editor Plugins - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.server.plugin.bpmn.executable;

import java.io.File;

import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.BPMNExportFormat;
import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.BPMNProjectInstance;
import com.ebmwebsourcing.petalsbpm.server.plugin.bpmn.descriptive.DescriptiveBPMNFileReader;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceFormat;
import com.ebmwebsourcing.webeditor.impl.domain.exception.ServiceException;

public class ExecutableBPMNFileReader extends DescriptiveBPMNFileReader{

    @Override
    public void readFile(File projectFile, IProjectInstanceFormat projectFilesFormat, BPMNProjectInstance instance) throws ServiceException{
        try{
            switch ((BPMNExportFormat)projectFilesFormat) {
            case BPMN:
                    super.readFile(projectFile, projectFilesFormat, instance);
                break;
            default:
                throw new ServiceException("This format ("+projectFilesFormat+") is not supported.");
            }
        }
        catch(Exception e){
            e.printStackTrace();
            throw new ServiceException(e.getMessage());
        }
    }
    
}
