/**
 * bpmn-plugins - Geasy BPMN Editor Plugins - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.descriptive.choreography;

import com.ebmwebsourcing.geasytools.webeditor.api.components.IContentPanelComponent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.diagram.ChoreographyPanel;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.mock.IdGenerator;
import com.ebmwebsourcing.petalsbpm.business.domain.di.impl.BPMNChoreographyDiagram;
import com.ebmwebsourcing.petalsbpm.client.component.bpmn.ChoreographyPanelComponent;
import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.descriptive.DescriptiveBPMNProjectInstance;
import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.descriptive.DescriptiveBPMNProjectPlugin;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectType;
import com.ebmwebsourcing.webeditor.impl.domain.user.User;

public class BPMNChoreographyPlugin extends DescriptiveBPMNProjectPlugin {

	public BPMNChoreographyPlugin() {
		super(new ChoreographyProjectType());

	}

	@Override
	public IContentPanelComponent getContentPanelComponent(
			DescriptiveBPMNProjectInstance projectInstance) {
        ChoreographyPanelComponent c = new ChoreographyPanelComponent(this,new ChoreographyPanel(800, 600));
        c.loadProjectInstance(projectInstance);
        return c;
	}

    @Override
    public DescriptiveBPMNProjectInstance createNewProjectInstance() {
    	
    	DescriptiveBPMNProjectInstance bpmnProjectInstance = new DescriptiveBPMNProjectInstance(getProjectType());
		bpmnProjectInstance.setBpmndiagram(new BPMNChoreographyDiagram());
    	bpmnProjectInstance.setId(IdGenerator.createUniqueId());
		
		//TODO: replace by a true request
		User user = new User();
		user.setLogin("user1");
		user.setId("user1ID");

		bpmnProjectInstance.setAuthor(user);
    	
		return bpmnProjectInstance;
    }
	
}
