/**
 * definitions-editor - BPMN Definitions Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.definitionseditor;

import com.ebmwebsourcing.petalsbpm.definitionseditor.definitions.DefinitionsPropertiesPanel;
import com.ebmwebsourcing.petalsbpm.definitionseditor.error.ErrorPanel;
import com.ebmwebsourcing.petalsbpm.definitionseditor.eventdefinition.conditional.ConditionalEventDefinitionPanel;
import com.ebmwebsourcing.petalsbpm.definitionseditor.eventdefinition.message.MessageEventDefinitionPanel;
import com.ebmwebsourcing.petalsbpm.definitionseditor.eventdefinition.signal.SignalEventDefinitionPanel;
import com.ebmwebsourcing.petalsbpm.definitionseditor.eventdefinition.timer.TimerEventDefinitionPanel;
import com.ebmwebsourcing.petalsbpm.definitionseditor.imports.ImportPanel;
import com.ebmwebsourcing.petalsbpm.definitionseditor.interfaces.InterfacePanel;
import com.ebmwebsourcing.petalsbpm.definitionseditor.itemdefinition.ItemDefinitionPanel;
import com.ebmwebsourcing.petalsbpm.definitionseditor.message.MessagePanel;
import com.ebmwebsourcing.petalsbpm.definitionseditor.namespace.NamespacePanel;
import com.ebmwebsourcing.petalsbpm.definitionseditor.signal.SignalPanel;
import com.google.gwt.user.client.ui.Composite;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.TabPanel;

public class DefinitionsEditor extends Composite {

	
	private TabPanel tabPanel;
	
	private ImportPanel importPanel;
	private NamespacePanel importNSPanel;
	private ItemDefinitionPanel itemDefinitionPanel;
	private MessagePanel messagePanel;
	private ErrorPanel errorPanel;
	private InterfacePanel interfacePanel;
	private SignalPanel signalPanel;
	
	private ConditionalEventDefinitionPanel conditionalEventDefinitionPanel;
	private MessageEventDefinitionPanel messageEventDefinitionPanel;
	private SignalEventDefinitionPanel signalEventDefinitionPanel;
	private TimerEventDefinitionPanel timerEventDefinintionPanel;

	private TabPanel eventDefinitionspanel;

	private DefinitionsPropertiesPanel definitionsPropertiesPanel;
	
	public DefinitionsEditor(Configuration conf) {
		
		this.tabPanel = new TabPanel();
		

		this.tabPanel.setHeight(500);
		this.tabPanel.setWidth(800);
		this.tabPanel.setEnableTabScroll(true);
		
		
		//Definition Properties
		this.definitionsPropertiesPanel = new DefinitionsPropertiesPanel("Properties"); 
		this.tabPanel.add(definitionsPropertiesPanel);
		

		//Import
		this.importPanel = new ImportPanel(); 
		importPanel.setTitle("Imports");
		if (conf.isShowImportPanel()) this.tabPanel.add(importPanel);
		
		//Imports Namespace Declarations
		this.importNSPanel = new NamespacePanel();
		importNSPanel.setTitle("Namespaces");
		if (conf.isShowImportNSPanel()) this.tabPanel.add(importNSPanel);
		
		//ItemDefinition
		this.itemDefinitionPanel = new ItemDefinitionPanel();
		itemDefinitionPanel.setTitle("Item Definitions");
		if (conf.isShowitemDefinitionPanel()) this.tabPanel.add(itemDefinitionPanel);
		
		//Message
		this.messagePanel  = new MessagePanel();
		this.messagePanel.setTitle("Messages");
		if (conf.isShowMessagePanel()) this.tabPanel.add(messagePanel);
		
		//Error
		this.errorPanel   = new ErrorPanel();
		this.errorPanel.setTitle("Errors");
		if (conf.isShowErrorPanel()) this.tabPanel.add(errorPanel);
		
		//Interfaces
		Panel interfacePanelWrapper = new Panel("Interfaces");
		
		this.interfacePanel = new InterfacePanel();
		this.interfacePanel.setWrapper(interfacePanelWrapper);
		this.interfacePanel.setTitle("Interfaces");
		interfacePanelWrapper.add(this.interfacePanel);
		if (conf.isShowInterfacePanel()) this.tabPanel.add(interfacePanelWrapper);
		this.interfacePanel.setHeight(500);
		
		//Signals
		this.signalPanel  = new SignalPanel();
		this.signalPanel.setTitle("Signals");
		if (conf.isShowSignalPanel()) this.tabPanel.add(signalPanel);
		
		//Event Definitions
		this.eventDefinitionspanel  = new TabPanel();
		eventDefinitionspanel.setTitle("Event Definitions");
		
		Panel conditionalEDPWrapper = new Panel("Conditional");
		Panel messageEDPWrapper 	= new Panel("Message");
		Panel signalEDWrapper 		= new Panel("Signal");
		Panel timerEDWrapper 		= new Panel("Timer");
		
		this.conditionalEventDefinitionPanel = new ConditionalEventDefinitionPanel();
		this.conditionalEventDefinitionPanel.setHeight(440);
		conditionalEDPWrapper.add(conditionalEventDefinitionPanel);
		conditionalEDPWrapper.setBorder(false);
		
		this.messageEventDefinitionPanel = new MessageEventDefinitionPanel();
		this.messageEventDefinitionPanel.setHeight(440);
		messageEDPWrapper.add(messageEventDefinitionPanel);
		messageEDPWrapper.setBorder(false);
		
		this.signalEventDefinitionPanel = new SignalEventDefinitionPanel();
		this.signalEventDefinitionPanel.setHeight(440);
		signalEDWrapper.add(signalEventDefinitionPanel);
		signalEDWrapper.setBorder(false);
		
		this.timerEventDefinintionPanel = new TimerEventDefinitionPanel();
		this.timerEventDefinintionPanel.setHeight(440);
		timerEDWrapper.add(timerEventDefinintionPanel);
		timerEDWrapper.setBorder(false);
		
		eventDefinitionspanel.add(conditionalEDPWrapper);
		eventDefinitionspanel.add(messageEDPWrapper);
		eventDefinitionspanel.add(signalEDWrapper);
		eventDefinitionspanel.add(timerEDWrapper);
		
		if (conf.isShowEventDefinitionPanel()) tabPanel.add(eventDefinitionspanel);
		
//		this.tabPanel.add(new DefinitionsPropertiesPanel("Signal"));
//		this.tabPanel.add(new DefinitionsPropertiesPanel("Escalation"));
//		this.tabPanel.add(new DefinitionsPropertiesPanel("Event Definitions"));
//		this.tabPanel.add(new DefinitionsPropertiesPanel("Event Definition"));
//		this.tabPanel.add(new DefinitionsPropertiesPanel("Partner Entities"));
//		this.tabPanel.add(new DefinitionsPropertiesPanel("Partner Roles"));
		
		//Event Definitions
		
		



		this.tabPanel.doLayout();
		initWidget(tabPanel);
		
	}
	
	@Override
	protected void onLoad() {
		//Seems to be the only way to force tabPanel components to be rendered
		//into tabPanel rather than in rootPanel on initialization
		
		for(int i=tabPanel.getComponents().length;i>=0;i--){
			
			tabPanel.setActiveTab(i);
			
		}
		//this.tabPanel.setActiveTab(3);
		
		for(int i=eventDefinitionspanel.getComponents().length;i>=0;i--){
			
			eventDefinitionspanel.setActiveTab(i);
			
		}			
		this.eventDefinitionspanel.setActiveTab(0);
	
	
	}
	
	public DefinitionsPropertiesPanel getDefinitionsPropertiesPanel() {
		return definitionsPropertiesPanel;
	}
	
	public InterfacePanel getInterfacePanel() {
		return interfacePanel;
	}
	
	public ErrorPanel getErrorPanel() {
		return errorPanel;
	}
	
	public ImportPanel getImportPanel() {
		return importPanel;
	}
	
	public NamespacePanel getImportNSPanel() {
		return importNSPanel;
	}
	
	public ItemDefinitionPanel getItemDefinitionPanel() {
		return itemDefinitionPanel;
	}
	
	public MessagePanel getMessagePanel() {
		return messagePanel;
	}
	
	public SignalPanel getSignalPanel() {
		return signalPanel;
	}
	
	public ConditionalEventDefinitionPanel getConditionalEventDefinitionPanel() {
		return conditionalEventDefinitionPanel;
	}
	
	public MessageEventDefinitionPanel getMessageEventDefinitionPanel() {
		return messageEventDefinitionPanel;
	}
	
	public SignalEventDefinitionPanel getSignalEventDefinitionPanel() {
		return signalEventDefinitionPanel;
	}
	
	public TimerEventDefinitionPanel getTimerEventDefinintionPanel() {
		return timerEventDefinintionPanel;
	}
	
}
