/**
 * definitions-editor - BPMN Definitions Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.definitionseditor.imports;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.infrastructure.IImportBean;

/**
 * Stores only available import (imports that are not actually imported in a definition)
 * 
 * @author nfleury
 *
 */
public class DefinitionsAvailableImport {

	
	
	private List<IImportBean> imports = new ArrayList<IImportBean>();
	
	private static DefinitionsAvailableImport instance;
	
	private DefinitionsAvailableImport() {
		
		
		
	}
	
	
	public static DefinitionsAvailableImport getInstance() {
		
		if (instance==null){
			instance = new DefinitionsAvailableImport();
		}
		
		return instance;
	}
	
	

	public void addImport(IImportBean XSDImport){
		imports.add(XSDImport);
	}
	
	
	public void removeImport(IImportBean impt) {
	    imports.remove(impt);
	}
	
	
	public List<IImportBean> getImports() {
		return imports;
	}
	
	
}
