/**
 * definitions-editor - BPMN Definitions Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.definitionseditor.signal;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.AbstractEditableGrid;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IItemDefinitionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.ISignalBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.SignalBean;
import com.ebmwebsourcing.petalsbpm.definitionseditor.Constants.Signal;
import com.google.gwt.user.client.DOM;
import com.gwtext.client.data.FieldDef;
import com.gwtext.client.data.ObjectFieldDef;
import com.gwtext.client.data.Record;
import com.gwtext.client.data.StringFieldDef;
import com.gwtext.client.widgets.form.TextField;
import com.gwtext.client.widgets.grid.BaseColumnConfig;
import com.gwtext.client.widgets.grid.ColumnConfig;
import com.gwtext.client.widgets.grid.EditorGridPanel;
import com.gwtext.client.widgets.grid.GridEditor;

public class SignalPanel extends AbstractEditableGrid<ISignalBean>{

	private ColumnConfig structureRefColumn;

	public SignalPanel() {
		super();

	}
	
	@Override
	protected void buildGrid() {
		super.buildGrid();
		gridPanel.getView().setForceFit(true);
	}
	
	@Override
	protected void bind(Record record, ISignalBean value) {
		value.setName(record.getAsString(Signal.name.toString()));
		value.setStructureRef((IItemDefinitionBean) record.getAsObject(Signal.structureRef.toString()));
	}

	@Override
	protected String getAddText() {
		return "Add Signal";
	}

	@Override
	protected ISignalBean getNewDefaultRecord() {
		return new SignalBean(DOM.createUniqueId());
	}

	@Override
	protected String getRemoveText() {
		return "Remove Signal";
	}

	@Override
	protected Object[] convertDataToObject(ISignalBean data) {
		
		Object[] object = new Object[2];
		
		object[0] = data.getName();
		object[1] = data.getStructureRef();
		
		
		return object;
	}

	@Override
	protected List<BaseColumnConfig> getColumnsConfig() {
		
		ArrayList<BaseColumnConfig> cc 		= new ArrayList<BaseColumnConfig>();
		
		ColumnConfig signalName 	= new ColumnConfig(Signal.name.getLabel(), Signal.name.toString());
		signalName.setEditor(new GridEditor(new TextField()));
		
		this.structureRefColumn = new ColumnConfig(Signal.structureRef.getLabel(), Signal.structureRef.toString());
		
		cc.add(signalName);
		cc.add(structureRefColumn);
		
		return cc;
	}

	public ColumnConfig getStructureRefColumn() {
		return structureRefColumn;
	}
	
	@Override
	protected FieldDef[] getFieldDef() {
		return new FieldDef[]{
				new StringFieldDef(Signal.name.toString()),
				new ObjectFieldDef(Signal.structureRef.toString()),
		};
	}
	
	@Override
	protected EditorGridPanel getGridPanel() {
		return super.getGridPanel();
	}

	@Override
	protected boolean isValid(ISignalBean data) {
		
		if (data.getName()!=null && data.getName().equals("")==false){
			return true;
		}
		
		return false;
	}
	
}
