/**
 * governance - A Web based designer for BPMN 2.0 standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.governance.client.master;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.ebmwebsourcing.geasywebeditor.client.file.repository.FileRepositoryDescription;
import com.ebmwebsourcing.geasywebeditor.client.file.repository.to.SearchFormData;
import com.ebmwebsourcing.geasywebeditor.client.file.repository.ui.SearchForm;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.form.Checkbox;
import com.gwtext.client.widgets.form.FormPanel;
import com.gwtext.client.widgets.form.MultiFieldPanel;
import com.gwtext.client.widgets.form.TextField;
import com.gwtext.client.widgets.layout.ColumnLayoutData;

public class PetalsMasterDescription extends FileRepositoryDescription {

    public PetalsMasterDescription() {
        super("wsdl", "Petals Master",
                "com.ebmwebsourcing.petalsbpm.governance.server.master.PetalsMasterInquiryService",
                "http://bpmneditor.ebmwebsourcing.com/petals-master-1.0/");
    }

    public SearchForm getSearchForm() {
        return new PetalsMasterSearchForm();
    }

    private class PetalsMasterSearchForm extends SearchForm {

        private Map<String, PetalsMasterSearchCriteria> criteria;
        private List<Checkbox> checkBoxes;
        private TextField keywords;

        public PetalsMasterSearchForm() {
            super();
            buildPanel();
        }

        private Panel buildPanel() {
            Panel mainPanel = new Panel();
            mainPanel.setBorder(false);

            FormPanel formPanel = new FormPanel();
            formPanel.setLabelWidth(100);
            formPanel.setBorder(false);

            keywords = new TextField("Search Keywords", "keywords", 250);
            keywords.setBlankText("This field is required.");
            keywords.setAllowBlank(false);
            formPanel.add(keywords);

            checkBoxes = new ArrayList<Checkbox>();
            MultiFieldPanel mfp = null;
            boolean first = true;

            this.criteria = new HashMap<String, PetalsMasterSearchCriteria>();
            for (PetalsMasterSearchCriteria sc : PetalsMasterSearchCriteria.values()) {
                criteria.put(sc.getDisplay(), sc);
                Checkbox r = new Checkbox(sc.getDisplay());
                if (first) {
                    r.setLabel("Search by:");
                    r.setChecked(true);
                    first = false;
                }
                if (mfp == null) {
                    MultiFieldPanel p = new MultiFieldPanel();
                    p.setBorder(false);
                    p.addToRow(r, 250);
                    formPanel.add(p);
                    mfp = p;
                } else {
                    r.setHideLabel(true);
                    mfp.addToRow(r, new ColumnLayoutData(1));
                    mfp = null;
                }
                checkBoxes.add(r);
            }

            mainPanel.add(formPanel);

            return mainPanel;
        }

        @Override
        public SearchFormData getInformation() {
            List<PetalsMasterSearchCriteria> sc = new ArrayList<PetalsMasterSearchCriteria>();
            for (Checkbox cb : checkBoxes) {
                if (cb.getValue()) {
                    sc.add(criteria.get(cb.getBoxLabel()));
                }
            }

            PetalsMasterSearchFormData result = new PetalsMasterSearchFormData();
            result.setCriteria(sc);
            result.setSearchPhrase(keywords.getText());

            return result;
        }

        @Override
        public String isInformationReady() {
            boolean textOK = keywords.getText() != null && !keywords.getText().isEmpty();

            boolean checked = false;
            for (Checkbox cb : checkBoxes) {
                if (cb.getValue()) {
                    checked = true;
                    break;
                }
            }

            String msg = null;
            if (!textOK || !checked) {
                msg = "Please enter a search phrase and check at least one of the checkboxes.";
            }

            return msg;
        }

        @Override
        public Widget asWidget() {
            return buildPanel();
        }

    }

}
