/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.addressing.descriptor;

import com.ebmwebsourcing.addressing.descriptor.AddressingException;
import com.ebmwebsourcing.addressing.descriptor.XmlUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.axiom.om.OMElement;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.w3._2005._08.addressing.AttributedURIType;
import org.w3._2005._08.addressing.EndpointReferenceType;
import org.w3._2005._08.addressing.ObjectFactory;
import org.w3._2005._08.addressing.ReferenceParametersType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Endpoint
extends EndpointReferenceType {
    public static final String XSD_ADDRESSING = "addressing.xsd";
    public static final String XSD_POLICY = "policy.xsd";
    private static Unmarshaller unmarshaller = null;
    private static AddressingException unmarshallerCreationEx = null;
    private static Marshaller marshaller = null;
    private static AddressingException marshallerCreationEx = null;
    private ObjectFactory factory;

    public Endpoint(String endpoint) throws URISyntaxException, AddressingException {
        this(new URI(endpoint), null, null, null, null);
    }

    public Endpoint(String endpoint, QName serviceName, QName interfaceName, List<Policy> policies) throws URISyntaxException, AddressingException {
        this(new URI(endpoint), null, serviceName, interfaceName, policies);
    }

    public Endpoint(URI endpoint, ReferenceParametersType referenceParameters, QName interfaceName, QName serviceName, List<Policy> policies) throws AddressingException {
        this.factory = new ObjectFactory();
        AttributedURIType adr = new AttributedURIType();
        adr.setValue(endpoint.toString());
        this.setAddress(adr);
        if (serviceName != null) {
            this.getAddress().getOtherAttributes().put(new QName("service"), serviceName.toString());
        }
        if (interfaceName != null) {
            this.getAddress().getOtherAttributes().put(new QName("interface"), interfaceName.toString());
        }
        this.setReferenceParameters(referenceParameters);
        this.setPolicy(policies);
    }

    private Endpoint(EndpointReferenceType epr) {
        this.address = epr.getAddress();
        this.any = epr.getAny();
        this.metadata = epr.getMetadata();
        this.referenceParameters = epr.getReferenceParameters();
    }

    private JAXBElement<EndpointReferenceType> getEndpointReference() {
        return this.factory.createEndpointReference(this);
    }

    private List<Element> convertPolicies2Elements(List<Policy> policies) throws AddressingException {
        ArrayList<Element> res = new ArrayList<Element>();
        for (Policy policy : policies) {
            res.add(this.convertPolicy2Element(policy));
        }
        return res;
    }

    private Element convertPolicy2Element(Policy p) throws AddressingException {
        Element res = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            XMLStreamWriter writer = factory.createXMLStreamWriter(out);
            p.serialize(writer);
            out.close();
            String policy = out.toString() + "</wsp:Policy>";
            ByteArrayInputStream input = new ByteArrayInputStream(policy.getBytes());
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(input);
            res = doc.getDocumentElement();
        }
        catch (XMLStreamException e) {
            throw new AddressingException(e);
        }
        catch (IOException e) {
            throw new AddressingException(e);
        }
        catch (SAXException e) {
            throw new AddressingException(e);
        }
        catch (ParserConfigurationException e) {
            throw new AddressingException(e);
        }
        return res;
    }

    public String marshall2String() throws AddressingException {
        try {
            StringWriter stringWriter = new StringWriter();
            Endpoint.getMarshaller().marshal(this.getEndpointReference(), (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (JAXBException e) {
            throw new AddressingException("Failed to build XML binding from EndpointReference descriptor Java classes", e);
        }
    }

    public Element marshall2Element() throws AddressingException {
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Endpoint.getMarshaller().marshal(this.getEndpointReference(), (Node)doc);
        }
        catch (JAXBException ex) {
            throw new AddressingException("Failed to build XML binding from EndpointReference descriptor Java classes", ex);
        }
        catch (ParserConfigurationException ex) {
            throw new AddressingException("Failed to build XML binding from EndpointReference descriptor Java classes", ex);
        }
        return doc.getDocumentElement();
    }

    public static Endpoint unmarshall(InputStream EndpointReferenceDescriptorStream) throws AddressingException {
        try {
            JAXBElement EndpointReferenceBinding = Endpoint.getUnMarshaller().unmarshal((Source)new StreamSource(EndpointReferenceDescriptorStream), EndpointReferenceType.class);
            return new Endpoint((EndpointReferenceType)EndpointReferenceBinding.getValue());
        }
        catch (JAXBException e) {
            throw new AddressingException("Failed to build Java bindings from EndpointReference descriptor XML document", e);
        }
    }

    public static Unmarshaller getUnMarshaller() throws AddressingException {
        if (unmarshallerCreationEx != null) {
            throw unmarshallerCreationEx;
        }
        return unmarshaller;
    }

    public static Marshaller getMarshaller() throws AddressingException {
        if (marshallerCreationEx != null) {
            throw marshallerCreationEx;
        }
        return marshaller;
    }

    public List<Policy> getPolicies() {
        ArrayList<Policy> policies = new ArrayList<Policy>();
        if (this.any != null) {
            for (Object elmt : this.any) {
                if (!(elmt instanceof Element)) continue;
                try {
                    Policy p = PolicyEngine.getPolicy((OMElement)XmlUtils.toOM((Element)elmt));
                    policies.add(p);
                }
                catch (Exception e) {}
            }
        }
        return policies;
    }

    public void setPolicy(List<Policy> policies) throws AddressingException {
        if (policies != null) {
            if (this.any == null) {
                this.any = new ArrayList();
            }
            for (Element e : this.convertPolicies2Elements(policies)) {
                this.any.add(e);
            }
        }
    }

    static {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            JAXBContext jaxbContext;
            URL schemaUrl = Endpoint.class.getResource("/addressing.xsd");
            URL schemaPolicyUrl = Endpoint.class.getResource("/policy.xsd");
            Schema schema = factory.newSchema(new StreamSource[]{new StreamSource(schemaUrl.openStream()), new StreamSource(schemaPolicyUrl.openStream())});
            try {
                jaxbContext = JAXBContext.newInstance((Class[])new Class[]{EndpointReferenceType.class, Policy.class});
                unmarshaller = jaxbContext.createUnmarshaller();
            }
            catch (JAXBException e) {
                unmarshallerCreationEx = new AddressingException("Failed to create the JAXB unmarshaller", e);
            }
            try {
                jaxbContext = JAXBContext.newInstance((Class[])new Class[]{EndpointReferenceType.class, Policy.class});
                marshaller = jaxbContext.createMarshaller();
            }
            catch (JAXBException e) {
                marshallerCreationEx = new AddressingException("Failed to create the JAXB marshaller", e);
            }
        }
        catch (IOException e) {
            AddressingException schemaCreationEx = new AddressingException("Failed to get resource 'addressing.xsd'from the current class-path", e);
            unmarshallerCreationEx = new AddressingException("Failed to create the JAXB unmarshaller", schemaCreationEx);
            marshallerCreationEx = new AddressingException("Failed to create the JAXB marshaller", schemaCreationEx);
        }
        catch (SAXException e) {
            AddressingException schemaCreationEx = new AddressingException("Failed to parse resource 'addressing.xsd'", e);
            unmarshallerCreationEx = new AddressingException("Failed to create the JAXB unmarshaller", schemaCreationEx);
            marshallerCreationEx = new AddressingException("Failed to create the JAXB marshaller", schemaCreationEx);
        }
    }
}

