/**
 * Web commons : user service.
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * RoleManagerImpl.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.webcommons.user.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import org.apache.log4j.Logger;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

import com.ebmwebsourcing.webcommons.aop.annotation.CheckAllArgumentsNotNull;
import com.ebmwebsourcing.webcommons.user.api.service.RoleGroupException;
import com.ebmwebsourcing.webcommons.user.api.service.RoleManager;
import com.ebmwebsourcing.webcommons.user.persistence.bo.Role;
import com.ebmwebsourcing.webcommons.user.persistence.dao.RoleDAO;

/**
 * 
 * @author strino
 * 
 */
public class RoleManagerImpl implements RoleManager {

    private final Logger logger = Logger.getLogger(this.getClass());

    private RoleDAO roleDAO;

    private Resource rolesResource;

    private RoleManager roleManager;

    public void nonTransactionalInit() throws IOException, RoleGroupException {
        logger.debug("###### Initialize RoleManager bean");
        roleManager.init();
        logger.debug("###### RoleManager bean initialized");
    }

    public void setRolesResource(Resource resource) {
        this.rolesResource = resource;
    }

    public void init() throws IOException {
        // Retrieve role list
        Properties rolesProps = PropertiesLoaderUtils.loadProperties(rolesResource);
        Object[] roles = rolesProps.keySet().toArray(new Object[0]);

        // Register roles in database
        for (Object enumRole : roles) {
            logger.debug("Create role : " + (String) enumRole);
            createRole((String) enumRole);
        }
    }

    @CheckAllArgumentsNotNull
    public void createRole(String roleName) {

        // Retrieve if the role already exist
        Role role = this.roleDAO.getRoleByName(roleName);

        if (role == null) {
            role = new Role();
            role.setName(roleName);

            // Insert the role in registry
            this.roleDAO.save(role);
        }
    }

    public String[] getAllRoles() {
        List<String> stringRoles = new ArrayList<String>();

        List<Role> roles = this.roleDAO.getAll();
        for (Role role : roles) {
            stringRoles.add(role.getName());
        }
        return stringRoles.toArray(new String[0]);
    }

    public void setRoleDAO(RoleDAO roleDAO) {
        this.roleDAO = roleDAO;
    }

    public void setRoleManager(RoleManager roleManager) {
        this.roleManager = roleManager;
    }

}
