/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.webcommons.user.service;

import com.ebmwebsourcing.webcommons.aop.annotation.CheckAllArgumentsNotNull;
import com.ebmwebsourcing.webcommons.user.api.service.RoleGroupException;
import com.ebmwebsourcing.webcommons.user.api.service.UserException;
import com.ebmwebsourcing.webcommons.user.api.service.UserManager;
import com.ebmwebsourcing.webcommons.user.api.to.UserTO;
import com.ebmwebsourcing.webcommons.user.persistence.bo.RoleGroup;
import com.ebmwebsourcing.webcommons.user.persistence.bo.User;
import com.ebmwebsourcing.webcommons.user.persistence.dao.RoleGroupDAO;
import com.ebmwebsourcing.webcommons.user.persistence.dao.UserDAO;
import com.ebmwebsourcing.webcommons.user.service.RolesAndUsersTransfertObjectAssembler;
import com.ebmwebsourcing.webcommons.util.StringHelper;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserManagerImpl
implements UserManager {
    private final Logger logger = Logger.getLogger(this.getClass());
    private RolesAndUsersTransfertObjectAssembler rolesAndUsersTransfertObjectAssembler;
    private UserDAO userDAO;
    private RoleGroupDAO roleGroupDAO;
    private Resource usersResource;
    private Resource passwordsResource;
    private UserManager userManager;

    public void nonTransactionalInit() throws IOException, RoleGroupException {
        this.logger.debug((Object)"###### Initialize usermanagerbean");
        this.userManager.init();
        this.logger.debug((Object)"######  usermanagerbean Initialized");
    }

    @Override
    public void init() throws IOException, RoleGroupException {
        Properties usersProps = PropertiesLoaderUtils.loadProperties((Resource)this.usersResource);
        Map<String, List<String>> usersMap = this.createUserToRoleGroupMap(usersProps);
        Properties passwordsProps = PropertiesLoaderUtils.loadProperties((Resource)this.passwordsResource);
        for (String userName : usersMap.keySet()) {
            this.logger.debug((Object)("Create user : " + userName));
            this.createUser(userName, usersMap.get(userName), passwordsProps.getProperty(userName));
        }
    }

    private Map<String, List<String>> createUserToRoleGroupMap(Properties usersProps) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (Object userProp : usersProps.keySet()) {
            ArrayList<String> roleGroupList = new ArrayList<String>();
            String roleGroups = usersProps.getProperty((String)userProp);
            StringTokenizer tokenizer = new StringTokenizer(roleGroups, ",");
            while (tokenizer.hasMoreElements()) {
                String roleGroupName = tokenizer.nextToken();
                roleGroupList.add(roleGroupName.trim());
            }
            result.put((String)userProp, roleGroupList);
        }
        return result;
    }

    private void createUser(String userName, List<String> roleGroupNames, String password) throws RoleGroupException {
        User userBO = this.userDAO.getUserByName(userName);
        if (userBO == null) {
            User user = new User();
            user.setName(userName);
            user.setPassword(password);
            List<RoleGroup> listRoleGroup = this.retrieveRoleGroups(roleGroupNames);
            user.setListRoleGroup(listRoleGroup);
            this.userDAO.save((Object)user);
        }
    }

    private List<RoleGroup> retrieveRoleGroups(List<String> roleGroupNames) throws RoleGroupException {
        ArrayList<RoleGroup> roleGroups = new ArrayList<RoleGroup>();
        for (String string : roleGroupNames) {
            RoleGroup roleGroup = this.roleGroupDAO.getRoleGroupByName(string);
            if (roleGroup != null) {
                roleGroups.add(roleGroup);
                continue;
            }
            throw new RoleGroupException("Can't create user because role group '" + string + "' doesn't exist");
        }
        return roleGroups;
    }

    @Override
    @CheckAllArgumentsNotNull
    public String createUser(UserTO userTO) throws UserException {
        User user = new User();
        this.validateUserBeforSaveOrUpdate(userTO, null);
        this.rolesAndUsersTransfertObjectAssembler.toUserBO(userTO, user);
        return ((User)((Object)this.userDAO.save((Object)user))).getId();
    }

    @Override
    public List<UserTO> getAllUser() throws UserException {
        ArrayList<UserTO> listUserTO = new ArrayList<UserTO>();
        List listUser = this.userDAO.getAll();
        for (User us : listUser) {
            UserTO userTO = this.rolesAndUsersTransfertObjectAssembler.toUserTO(us);
            listUserTO.add(userTO);
        }
        return listUserTO;
    }

    @Override
    @CheckAllArgumentsNotNull
    public List<UserTO> getUserNotInRoleGroup(String idRoleGroup) throws UserException {
        ArrayList<UserTO> listUserTO = new ArrayList<UserTO>();
        RoleGroup roleGroup = (RoleGroup)((Object)this.roleGroupDAO.get((Serializable)((Object)idRoleGroup)));
        if (roleGroup == null) {
            throw new UserException("A role with that name not exists ! ");
        }
        List<User> listUserInRole = roleGroup.getListUser();
        List allUser = this.userDAO.getAll();
        if (allUser != null) {
            if (!listUserInRole.isEmpty()) {
                allUser.removeAll(listUserInRole);
            }
            for (User us : allUser) {
                listUserTO.add(this.rolesAndUsersTransfertObjectAssembler.toUserTO(us));
            }
        }
        return listUserTO;
    }

    @Override
    @CheckAllArgumentsNotNull
    public UserTO getUser(String userId) throws UserException {
        User user = (User)((Object)this.userDAO.get((Serializable)((Object)userId)));
        if (user == null) {
            throw new UserException("Can not find user in database ");
        }
        UserTO userTO = this.rolesAndUsersTransfertObjectAssembler.toUserTO(user);
        return userTO;
    }

    @Override
    public UserTO getUserByLogin(String login) throws UserException {
        User user = this.userDAO.getUserByName(login);
        if (user == null) {
            throw new UserException("Authentication failed : user '" + login + "' not found in database : ");
        }
        UserTO userTO = this.rolesAndUsersTransfertObjectAssembler.toUserTO(user);
        return userTO;
    }

    @Override
    @CheckAllArgumentsNotNull
    public void removeUser(String userId) throws UserException {
        User user = (User)((Object)this.userDAO.get((Serializable)((Object)userId)));
        if (user == null) {
            throw new UserException("Can not find and remove user in database ");
        }
        this.userDAO.remove((Object)user);
    }

    @Override
    @CheckAllArgumentsNotNull
    public String updateUser(UserTO userTO) throws UserException {
        String id = userTO.getId();
        if (id == null) {
            throw new UserException("This user doesn't exist in database ");
        }
        User user = (User)((Object)this.userDAO.get((Serializable)((Object)userTO.getId())));
        if (user == null) {
            throw new UserException("This user doesn't exist in database ");
        }
        this.validateUserBeforSaveOrUpdate(userTO, user.getName());
        this.rolesAndUsersTransfertObjectAssembler.toUserBO(userTO, user);
        return ((User)((Object)this.userDAO.save((Object)user))).getId();
    }

    @Override
    @CheckAllArgumentsNotNull
    public void addRoleGroup(String idUser, String idRoleGroup) throws UserException {
        User user = (User)((Object)this.userDAO.get((Serializable)((Object)idUser)));
        if (user == null) {
            throw new UserException("You are trying to add a role to a non existing user with id: " + idUser);
        }
        RoleGroup roleGroup = (RoleGroup)((Object)this.roleGroupDAO.get((Serializable)((Object)idRoleGroup)));
        if (roleGroup == null) {
            throw new UserException("You are trying to add a non existing role to an user. Role id: " + idRoleGroup);
        }
        user.addRoleGroup(roleGroup);
        this.userDAO.save((Object)user);
    }

    @Override
    @CheckAllArgumentsNotNull
    public void removeRoleGroup(String idUser, String idRoleGroup) throws UserException {
        User user = (User)((Object)this.userDAO.get((Serializable)((Object)idUser)));
        if (user == null) {
            throw new UserException("You are trying to remove a role to a non existing user with id: " + idUser);
        }
        RoleGroup roleGroup = (RoleGroup)((Object)this.roleGroupDAO.get((Serializable)((Object)idRoleGroup)));
        if (roleGroup == null) {
            throw new UserException("You are trying to remove a non existing role to an user. Role id: " + idRoleGroup);
        }
        user.removeRoleGroup(roleGroup);
        this.userDAO.save((Object)user);
    }

    private void validateUserBeforSaveOrUpdate(UserTO userTO, String nameUser) throws UserException {
        User user;
        String nameUserTO = userTO.getName();
        if (StringHelper.isNullOrEmpty((String)nameUserTO) || StringHelper.isNullOrEmpty((String)userTO.getPassword())) {
            throw new UserException("User Name and its password must be speficied.");
        }
        if (!nameUserTO.equalsIgnoreCase(nameUser) && (user = this.userDAO.getUserByName(nameUserTO)) != null) {
            throw new UserException("A user with that name already exists : " + nameUserTO);
        }
    }

    public void setRolesAndUsersTransfertObjectAssembler(RolesAndUsersTransfertObjectAssembler rolesAndUsersTransfertObjectAssembler) {
        this.rolesAndUsersTransfertObjectAssembler = rolesAndUsersTransfertObjectAssembler;
    }

    public void setUserDAO(UserDAO userDAO) {
        this.userDAO = userDAO;
    }

    public void setRoleGroupDAO(RoleGroupDAO roleGroupDAO) {
        this.roleGroupDAO = roleGroupDAO;
    }

    public void setUsersResource(Resource usersResource) {
        this.usersResource = usersResource;
    }

    public void setPasswordsResource(Resource passwordsResource) {
        this.passwordsResource = passwordsResource;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }
}

