/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.webcommons.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringHelper {
    public static boolean equal(String a, String b) {
        boolean result = a == null ? b == null : a.equals(b);
        return result;
    }

    public static boolean equalIgnoreCase(String a, String b) {
        boolean result = a == null ? b == null : a.equalsIgnoreCase(b);
        return result;
    }

    public static String extractValueForAttribute(String string, String attribute, String separator) {
        int start;
        String result = null;
        if (!StringHelper.isNullOrEmpty(string) && !StringHelper.isNullOrEmpty(attribute) && (start = string.indexOf(attribute)) >= 0 && start < string.length() && (start += attribute.length() + 1) < string.length()) {
            int end = 0;
            if (StringHelper.isNullOrEmpty(separator)) {
                end = string.length();
            } else {
                end = string.indexOf(separator, start);
                if (end < 0) {
                    end = string.length();
                }
            }
            result = string.substring(start, end);
        }
        return result;
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.trim().equals("");
    }

    public static List<String> splitPathElements(String path) {
        ArrayList<String> pathElements = new ArrayList<String>();
        if (!StringHelper.isNullOrEmpty(path)) {
            StringTokenizer tokenizer = new StringTokenizer(path, "/");
            while (tokenizer.hasMoreTokens()) {
                pathElements.add(tokenizer.nextToken());
            }
        }
        return pathElements;
    }

    public static String replace(String line, char oldChar, char newChar) {
        String result = "";
        if (line != null) {
            for (int j = 0; j < line.length(); ++j) {
                result = line.charAt(j) == oldChar ? result + newChar : result + line.charAt(j);
            }
        }
        return result;
    }

    public static String toString(InputStream inputStream) throws IOException {
        StringWriter writer = new StringWriter();
        InputStreamReader streamReader = new InputStreamReader(inputStream);
        BufferedReader buffer = new BufferedReader(streamReader);
        String line = "";
        while (null != (line = buffer.readLine())) {
            writer.write(line);
        }
        return writer.toString();
    }

    private StringHelper() {
    }
}

