/**
 * easyWSDL - easyWSDL toolbox Platform.
 * Copyright (c) 2008,  eBM Websourcing
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.ebmwebsourcing.addressing.addressing4agreement.monitoring.impl.inout;

import org.w3c.dom.Document;

import com.ebmwebsourcing.addressing.addressing4agreement.monitoring.api.EndpointReferenceType;
import com.ebmwebsourcing.addressing.addressing4agreement.monitoring.api.WSAddressing4AgreementWriter;
import com.ebmwebsourcing.wsstar.addressing.definition.WSAddressingFactory;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingWriter;
import com.ebmwebsourcing.wsstar.addressing.definition.decorator.DecoratorEndpointReferenceTypeImpl;


/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class WSAddressing4AgreementWriterImpl implements WSAddressing4AgreementWriter {

	WSAddressingWriter writer = null;

	public WSAddressing4AgreementWriterImpl() throws WSAddressingException {
		WSAddressingFactory factory = WSAddressingFactory.newInstance();
		factory.setJAXBObjectFactoryList(WSAddressing4AgreementJAXBContext.getDefaultObjectFactories());
		this.writer = factory.newWSAddressingWriter();
	}

	@SuppressWarnings("unchecked")
	public Document getDocument(final EndpointReferenceType eprDef) throws WSAddressingException {
		Document res = null;
		res = this.writer.getDocument(((DecoratorEndpointReferenceTypeImpl) eprDef).getFirstEpr());
		return res;
	}

	public boolean getFeature(final String name) throws IllegalArgumentException {
		return this.writer.getFeature(name);
	}

	public void setFeature(final String name, final boolean value) throws IllegalArgumentException {
		this.writer.setFeature(name, value);
	}

	@SuppressWarnings("unchecked")
	public String writeEndpointReferenceType(final EndpointReferenceType eprDef) throws WSAddressingException {
		String res = null;
		res = this.writer.writeEndpointReferenceType(((DecoratorEndpointReferenceTypeImpl) eprDef).getFirstEpr());
		return res;
	}

}
