/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.agreement.definition.impl;

import com.ebmwebsourcing.agreement.definition.api.Agreement;
import com.ebmwebsourcing.agreement.definition.api.WSAgreementException;
import com.ebmwebsourcing.agreement.definition.api.WSAgreementReader;
import com.ebmwebsourcing.agreement.definition.impl.AgreementImpl;
import com.ebmwebsourcing.agreement.definition.impl.AgreementTemplateImpl;
import com.ebmwebsourcing.agreement.definition.impl.AgreementTypeImpl;
import com.ebmwebsourcing.agreement.definition.impl.WSAgreementJAXBContext;
import com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.AgreementTemplateType;
import com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.AgreementType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.schema.util.SourceHelper;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSAgreementReaderImpl
implements WSAgreementReader {
    private static Logger log = Logger.getLogger(WSAgreementReaderImpl.class.getName());
    private Map<WSAgreementReader.FeatureConstants, Object> features = new HashMap<WSAgreementReader.FeatureConstants, Object>();
    private static Unmarshaller unmarshaller = null;
    private static WSAgreementException unmarshallerCreationEx = null;

    public WSAgreementReaderImpl() {
        this.features.put(WSAgreementReader.FeatureConstants.VERBOSE, false);
        this.features.put(WSAgreementReader.FeatureConstants.IMPORT_DOCUMENTS, true);
    }

    public static Unmarshaller getUnMarshaller() throws WSAgreementException {
        if (unmarshallerCreationEx != null) {
            throw unmarshallerCreationEx;
        }
        return unmarshaller;
    }

    public static JAXBContext getJaxbContext() {
        return WSAgreementJAXBContext.getJaxbContext();
    }

    @Override
    public Agreement readAgreement(URI uri) throws WSAgreementException {
        Agreement desc = null;
        try {
            InputStream input = null;
            File f = new File(uri.getPath());
            input = f.exists() ? new FileInputStream(f) : uri.toURL().openStream();
            desc = this.readAgreement(uri, new InputSource(input));
        }
        catch (MalformedURLException e) {
            throw new WSAgreementException("Can not get wsdl at: " + uri, e);
        }
        catch (IOException e) {
            throw new WSAgreementException("Can not get wsdl at: " + uri, e);
        }
        catch (SchemaException e) {
            throw new WSAgreementException("Can not get wsdl at: " + uri, e);
        }
        return desc;
    }

    @Override
    public Agreement readAgreement(Document document) throws WSAgreementException {
        Agreement desc = null;
        try {
            desc = this.readAgreement(new URI(document.getDocumentURI()), SourceHelper.convertDOMSource2InputSource((DOMSource)new DOMSource(document)));
        }
        catch (URISyntaxException e) {
            throw new WSAgreementException(e);
        }
        catch (XmlException e) {
            throw new WSAgreementException(e);
        }
        return desc;
    }

    @Override
    public Agreement readAgreement(URI uri, InputSource input) throws WSAgreementException {
        AgreementTypeImpl desc = null;
        try {
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            SAXSource saxSource = new SAXSource(xmlReader, input);
            JAXBElement agBinding = WSAgreementReaderImpl.getUnMarshaller().unmarshal((Source)saxSource, AgreementTemplateType.class);
            desc = ((AgreementTemplateType)agBinding.getValue()).getTemplateId() != null ? new AgreementTemplateImpl(uri, (AgreementTemplateType)agBinding.getValue(), this.getFeatures()) : new AgreementImpl(uri, (AgreementType)agBinding.getValue(), this.getFeatures());
        }
        catch (XmlException e) {
            throw new WSAgreementException(e);
        }
        catch (SAXException e) {
            throw new WSAgreementException(e);
        }
        catch (JAXBException e) {
            throw new WSAgreementException(e);
        }
        return desc;
    }

    @Override
    public void setFeature(WSAgreementReader.FeatureConstants name, Object value) throws IllegalArgumentException {
        this.features.put(name, value);
        log.finest("set features: name = " + (Object)((Object)name) + " - value = " + value);
    }

    @Override
    public Object getFeature(WSAgreementReader.FeatureConstants name) throws IllegalArgumentException {
        return this.features.get((Object)name);
    }

    @Override
    public Map<WSAgreementReader.FeatureConstants, Object> getFeatures() {
        return this.features;
    }

    public void setFeatures(Map<WSAgreementReader.FeatureConstants, Object> features) {
        this.features = features;
    }

    static {
        try {
            WSAgreementJAXBContext.createContext();
            unmarshaller = WSAgreementJAXBContext.getJaxbContext().createUnmarshaller();
        }
        catch (JAXBException e) {
            WSAgreementException jaxbContextCreationEx = new WSAgreementException("Failed to create jaxb context", e);
            unmarshallerCreationEx = new WSAgreementException("Failed to create the JAXB unmarshaller", (Throwable)((Object)jaxbContextCreationEx));
        }
        catch (SchemaException e) {
            WSAgreementException jaxbContextCreationEx = new WSAgreementException("Failed to create jaxb context", e);
            unmarshallerCreationEx = new WSAgreementException("Failed to create the JAXB unmarshaller", (Throwable)((Object)jaxbContextCreationEx));
        }
    }
}

