package com.ebmwebsourcing.agreement.definition.api;

import java.net.URI;
import java.util.List;

import javax.xml.namespace.QName;

public interface Agreement {

    /**
     * Set the document base URI of this definition. Can be used to represent
     * the origin of the Definition, and can be exploited when resolving
     * relative URIs (e.g. in &lt;import&gt;s).
     *
     * @param documentBaseURI
     *            the document base URI of this definition
     */
    public void setDocumentBaseURI(URI documentBaseURI);

    /**
     * Get the document base URI of this definition.
     *
     * @return the document base URI
     */
    public URI getDocumentBaseURI();
	
	QName getTagQName();
	
	void setTagQName(QName name);
	
	String getName(); 
	
	void setName(String name);
	
	Context newContext() throws WSAgreementException;
	
	Context getContext();
	
	void setContext(Context context);
	
	
	ServiceDescription newServiceDescription() throws WSAgreementException;
	
	ServiceDescription getServiceDescription();
	
	void setServiceDescription(ServiceDescription term);
	
	
	ServiceReference newServiceReference() throws WSAgreementException;
	
	ServiceReference getServiceReference();
	
	void setServiceReference(ServiceReference term);
	
	
	ServiceProperties newServiceProperties()  throws WSAgreementException;
	
	ServiceProperties getServiceProperties();
	
	void setServiceProperties(ServiceProperties term);
	

	
	GuaranteeTerms newGuaranteeTerms() throws WSAgreementException;
	
	List<GuaranteeTerms> getGuaranteeTerms();
	
	void setGuaranteeTerms(List<GuaranteeTerms> term);
	
	void addGuarantee(GuaranteeTerms term);
	
	void removeGuarantee(GuaranteeTerms term);
}
