package com.ebmwebsourcing.agreement.definition.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.BusinessValueListType;
import com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.ServiceLevelObjectiveType;
import com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.ServiceRoleType;
import com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.ServiceSelectorType;

import com.ebmwebsourcing.agreement.definition.api.BusinessValueList;
import com.ebmwebsourcing.agreement.definition.api.GuaranteeTerms;
import com.ebmwebsourcing.agreement.definition.api.QualifyingCondition;
import com.ebmwebsourcing.agreement.definition.api.ServiceLevelObjective;
import com.ebmwebsourcing.agreement.definition.api.ServiceScope;
import com.ebmwebsourcing.agreement.definition.api.WSAgreementException;

import sla.ebmwebsourcing.com.agreementextensions.TExpression;

public class GuaranteeTermsImpl extends AbstractSchemaElementImpl<com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.GuaranteeTermType> implements GuaranteeTerms {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(GuaranteeTermsImpl.class.getName());

	private com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.ObjectFactory factory = new com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.ObjectFactory();


	private List<ServiceScope> serviceScopes = new ArrayList<ServiceScope>();

	private QualifyingCondition qualifyingCondition;

	private ServiceLevelObjective slo;

	private BusinessValueList bvl;

	public GuaranteeTermsImpl(
			final com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.GuaranteeTermType model,
			final AbstractSchemaElementImpl parent)
	throws WSAgreementException {
		super(model, parent);

		for(ServiceSelectorType scope: this.model.getServiceScope()) {
			this.serviceScopes.add(new ServiceScopeImpl(scope, this));
		}

		if(this.model.getQualifyingCondition() != null) {
			this.qualifyingCondition = new QualifyingConditionImpl(this.model.getQualifyingCondition(), this);
		}
		if(this.model.getServiceLevelObjective() != null) {
			this.slo = new ServiceLevelObjectiveImpl(this.model.getServiceLevelObjective(), this);
		}
		if(this.model.getBusinessValueList() != null) {
			this.bvl = new BusinessValueListImpl(this.model.getBusinessValueList(), this);
		}
	}





	public BusinessValueList getBusinessValueList() {
		return this.bvl;
	}



	public QualifyingCondition getQualifyingCondition() {
		return this.qualifyingCondition;
	}



	public ServiceLevelObjective getServiceLevelObjective() {
		return this.slo;
	}



	public List<ServiceScope> getServiceScopes() {
		return this.serviceScopes;
	}



	public void setBusinessValueList(BusinessValueList bvl) {
		if(bvl != null) {
			this.model.setBusinessValueList((BusinessValueListType) ((AbstractSchemaElementImpl)bvl).getModel());
			this.bvl = bvl;
		}
	}



	public void setQualifyingCondition(QualifyingCondition q) {
		if((q != null)&&(q.getExpression() != null)) {
			this.model.setQualifyingCondition((TExpression)((AbstractSchemaElementImpl)q.getExpression()).getModel());
		}
		this.qualifyingCondition = q;
	}



	public void setServiceLevelObjective(ServiceLevelObjective slo) {
		if(slo != null) {
			this.model.setServiceLevelObjective((ServiceLevelObjectiveType) ((AbstractSchemaElementImpl)slo).getModel());
			this.slo = slo;
		}
	}


	public void addServiceScope(ServiceScope scopes) {
		if(scopes != null) {
			this.model.getServiceScope().add((ServiceSelectorType) ((AbstractSchemaElementImpl)scopes).getModel());
			this.serviceScopes.add(scopes);
		}
	}

	public void removeServiceScope(ServiceScope scopes) {
		if(scopes != null) {
			this.model.getServiceScope().remove((ServiceSelectorType) ((AbstractSchemaElementImpl)scopes).getModel());
			this.serviceScopes.remove(scopes);
		}
	}

	public BusinessValueList newBusinessValueList() throws WSAgreementException {
		return new BusinessValueListImpl(new BusinessValueListType(), null);
	}



	public QualifyingCondition newQualifyingCondition(String value, String expressionLanguage) throws WSAgreementException  {
		TExpression exp = new TExpression();
		exp.setValue(value);
		exp.setExpressionLanguage(expressionLanguage);
		return new QualifyingConditionImpl(factory.createQualifyingCondition(exp), this);
	}



	public ServiceLevelObjective newServiceLevelObjective() throws WSAgreementException {
		return new ServiceLevelObjectiveImpl(new ServiceLevelObjectiveType(), null);
	}



	public ServiceScope newServiceScope() throws WSAgreementException {
		return new ServiceScopeImpl(new ServiceSelectorType(), this);
	}





	public String getName() {

		return this.model.getName();
	}



	public void setName(String name) {
		this.model.setName(name);
	}





	public ServiceRoleType getObligated() {
		return this.model.getObligated();
	}





	public void setObligated(ServiceRoleType role) {
		this.model.setObligated(role);
	}



}
