package com.ebmwebsourcing.agreement.definition.impl;

import java.util.logging.Logger;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.addressing.addressing4agreement.monitoring.api.EndpointReferenceType;
import com.ebmwebsourcing.addressing.addressing4agreement.monitoring.impl.EndpointReferenceTypeImpl;
import com.ebmwebsourcing.agreement.definition.api.Location;
import com.ebmwebsourcing.agreement.definition.api.WSAgreementException;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.addressing.definition.api.absitf.AbsItfEndpointReferenceType;
import com.ebmwebsourcing.wsstar.qml.api.EquivalentTo;
import com.ebmwebsourcing.wsstar.qml.api.QOSDimension;
import com.ebmwebsourcing.wsstar.qml.api.WSQMLException;
import com.ebmwebsourcing.wsstar.qml.impl.EquivalentToImpl;
import com.ebmwebsourcing.wsstar.qml.impl.QOSDimensionImpl;



public class LocationImpl extends AbstractSchemaElementImpl<sla.ebmwebsourcing.com.agreementextensions.Location> implements Location {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(LocationImpl.class.getName());

	private EndpointReferenceType epr;

	private QOSDimension dimension;

	private EquivalentTo equivalentTo;

	public LocationImpl(
			final sla.ebmwebsourcing.com.agreementextensions.Location model,
			final AbstractSchemaElementImpl parent)
	throws WSAgreementException {
		super(model, parent);

		try {
			if(this.model.getAddress() != null) {
				this.epr = new EndpointReferenceTypeImpl((AbsItfEndpointReferenceType)new com.ebmwebsourcing.wsstar.addressing.definition.impl.EndpointReferenceTypeImpl(this.model.getAddress(), this));
			}

			if(this.model.getQoSDimension() != null) {
				this.dimension = new QOSDimensionImpl(this.model.getQoSDimension(), this);
			}

			if(this.model.getEquivalentTo() != null) {
				this.equivalentTo = new EquivalentToImpl(this.model.getEquivalentTo(), this);
			}
		} catch (WSAddressingException e) {
			throw new WSAgreementException(e);
		} catch (WSQMLException e) {
			throw new WSAgreementException(e);
		}

	}



	public EndpointReferenceType getAddress() {
		return this.epr;
	}



	public QOSDimension getQOSDimension() {
		return this.dimension;
	}



	public void setAddress(EndpointReferenceType epr) {
		this.model.setAddress((com.ebmwebsourcing.wsstar.addressing.definition.org.w3._2005._08.addressing.EndpointReferenceType) ((AbstractSchemaElementImpl)epr).getModel());
		this.epr = epr;
	}



	public void setQOSDimension(QOSDimension dim) {
		this.model.setQoSDimension((com.ebmwebsourcing.wsstar.qml.upmc.fr.QoSDimension) ((AbstractSchemaElementImpl)dim).getModel());
		this.dimension = dim;
	}



	public EquivalentTo getEquivalentTo() {
		return equivalentTo;
	}



	public void setEquivalentTo(EquivalentTo eq) {
		// TODO Auto-generated method stub
		
	}

}
