package com.ebmwebsourcing.agreement.definition.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;

import javax.xml.bind.JAXBElement;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.agreement.definition.api.Location;
import com.ebmwebsourcing.agreement.definition.api.Variable;
import com.ebmwebsourcing.agreement.definition.api.WSAgreementException;

public class VariableImpl extends AbstractSchemaElementImpl<com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.VariableType> implements Variable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(VariableImpl.class.getName());

	private sla.ebmwebsourcing.com.agreementextensions.ObjectFactory factory = new sla.ebmwebsourcing.com.agreementextensions.ObjectFactory();

	private Location location;

	public VariableImpl(
			final com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.VariableType model,
			final AbstractSchemaElementImpl parent)
	throws WSAgreementException {
		super(model, parent);

		if(this.model.getLocation() != null) {
			if(this.model.getLocation() instanceof JAXBElement) {
				if(((JAXBElement)this.model.getLocation()).getValue() instanceof sla.ebmwebsourcing.com.agreementextensions.Location) {
					location = new LocationImpl((sla.ebmwebsourcing.com.agreementextensions.Location) ((JAXBElement)this.model.getLocation()).getValue(), this);
				}
			} else if(this.model.getLocation() instanceof sla.ebmwebsourcing.com.agreementextensions.Location) {
				location = new LocationImpl((sla.ebmwebsourcing.com.agreementextensions.Location) this.model.getLocation(), this);
			}
		}
	}



	public URI getMetric(){
		URI metric = null;
		try {
			metric = new URI(this.model.getMetric());
		} catch (URISyntaxException e) {
			log.severe(e.getMessage());
		}
		return metric;
	}



	public String getName() {
		return this.model.getName();
	}



	public void setMetric(URI metric) {
		this.model.setMetric(metric.toString());
	}



	public void setName(String name) {
		this.model.setName(name);
	}



	public Location getLocation() {
		return this.location;
	}



	public void setLocation(Location location) {
		this.model.setLocation((sla.ebmwebsourcing.com.agreementextensions.Location) ((AbstractSchemaElementImpl)location).getModel());
		this.location = location;
	}



	public Location newLocation() throws WSAgreementException {
		return new LocationImpl(new sla.ebmwebsourcing.com.agreementextensions.Location(), this);
	}

}
