/**
 * easySchema - easyWSDL toolbox Platform.
 * Copyright (c) 2008,  eBM Websourcing
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.ebmwebsourcing.agreement.definition.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;

import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.schema.util.SourceHelper;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

import com.ebmwebsourcing.agreement.definition.api.Agreement;
import com.ebmwebsourcing.agreement.definition.api.WSAgreementException;
import com.ebmwebsourcing.agreement.definition.api.WSAgreementReader;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class WSAgreementReaderImpl implements WSAgreementReader {

	private static Logger log = Logger.getLogger(WSAgreementReaderImpl.class.getName());

	private Map<FeatureConstants, Object> features = new HashMap<FeatureConstants, Object>();

	/**
	 * The JAXB unique unmarshaller.
	 */




	public WSAgreementReaderImpl() throws WSAgreementException {
		this.features.put(FeatureConstants.VERBOSE, false);
		this.features.put(FeatureConstants.IMPORT_DOCUMENTS, true);
	}



	public Agreement readAgreement(final URI uri) throws WSAgreementException {
		Agreement desc = null;
		try {
			InputStream input = null;
			final File f = new File(uri.getPath());
			if (f.exists()) {
				input = new FileInputStream(f);
			} else {
				input = uri.toURL().openStream();
			}
			desc = this.readAgreement(uri, new InputSource(input));
		} catch (final MalformedURLException e) {
			throw new WSAgreementException("Can not get wsdl at: " + uri, e);
		} catch (final IOException e) {
			throw new WSAgreementException("Can not get wsdl at: " + uri, e);
		} catch (final SchemaException e) {
			throw new WSAgreementException("Can not get wsdl at: " + uri, e);
		}
		return desc;
	}

	public Agreement readAgreement(final Document document) throws WSAgreementException {
		Agreement desc = null;
		try {
			URI uri = null;
			if(document.getDocumentURI() != null) {
				uri = new URI(document.getDocumentURI());
			} else {
				uri = URI.create(".");
			}
			desc = this.readAgreement(uri, SourceHelper.convertDOMSource2InputSource(new DOMSource(document)));
		} catch (final URISyntaxException e) {
			throw new WSAgreementException(e);
		} catch (XmlException e) {
			throw new WSAgreementException(e);
		}

		return desc;
	}

	public Agreement readAgreement(final URI uri, final InputSource input) throws WSAgreementException {
		Agreement desc = null;
		try {

			XMLReader xmlReader = XMLReaderFactory.createXMLReader();
			SAXSource saxSource = new SAXSource(xmlReader, input);
			
			final JAXBElement<com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.AgreementTemplateType> agBinding = WSAgreementJAXBContext.getJaxbContext().createUnmarshaller()
			.unmarshal(saxSource,
					com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.AgreementTemplateType.class);
			
			if(agBinding.getValue().getTemplateId() != null) {
				desc = new AgreementTemplateImpl(uri, agBinding.getValue(), this.getFeatures());
			} else {
				desc = new AgreementImpl(uri, agBinding.getValue(), this.getFeatures());
			}
		} catch (final XmlException e) {
			throw new WSAgreementException(e);
		} catch (SAXException e) {
			throw new WSAgreementException(e);
		} catch (JAXBException e) {
			throw new WSAgreementException(e);
		}

		return desc;
	}

	public void setFeature(final FeatureConstants name, final Object value)
	throws IllegalArgumentException {
		this.features.put(name, value);
		log.finest("set features: name = " + name + " - value = " + value);
	}

	public Object getFeature(final FeatureConstants name) throws IllegalArgumentException {
		return this.features.get(name);
	}

	public Map<FeatureConstants, Object> getFeatures() {
		return this.features;
	}

	public void setFeatures(final Map<FeatureConstants, Object> features) {
		this.features = features;
	}
}
