/**
 * easySchema - easyWSDL toolbox Platform.
 * Copyright (c) 2008,  eBM Websourcing
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.ebmwebsourcing.agreement.definition.impl;

import java.io.StringWriter;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.apache.commons.lang.NotImplementedException;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.w3c.dom.Document;

import com.ebmwebsourcing.agreement.definition.api.Agreement;
import com.ebmwebsourcing.agreement.definition.api.WSAgreementException;
import com.ebmwebsourcing.agreement.definition.api.WSAgreementWriter;


/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class WSAgreementWriterImpl extends WSAgreementJAXBContext implements
        WSAgreementWriter {



    @SuppressWarnings("unchecked")
    private static Document convertAgreementType2DOMElement(final QName tagName,
            final com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.AgreementType def)
            throws WSAgreementException {
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();

            // TODO : Check if it is a Thread safe method
            final JAXBElement element = new JAXBElement(tagName, def.getClass(), def);

            WSAgreementJAXBContext.getJaxbContext().createMarshaller().marshal(element, doc);
        } catch (final JAXBException ex) {
            throw new WSAgreementException(
                    "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
        } catch (final ParserConfigurationException ex) {
            throw new WSAgreementException(
                    "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);

        }
        return doc;
    }

    @SuppressWarnings("unchecked")
    private static String convertAgreementType2String(
            final com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.AgreementType def)
            throws WSAgreementException {

        try {
            final StringWriter stringWriter = new StringWriter();
            // TODO : Check if it is a Thread safe method

            final JAXBElement element = new JAXBElement(new QName(Constants.WSAGREEMENT_NAMESPACE,
            		Constants.AGREEMENT_ROOT_TAG), def.getClass(), def);

            WSAgreementJAXBContext.getJaxbContext().createMarshaller().marshal(element, stringWriter);

            return stringWriter.toString();
        } catch (final JAXBException e) {
            throw new WSAgreementException(
                    "Failed to build XML binding from Agreement descriptor Java classes", e);
        }
    }



    public Document getDocument(final Agreement def) throws WSAgreementException {
        Document doc = null;
        if ((def != null)
                && (def instanceof Agreement)) {
                doc = WSAgreementWriterImpl
                        .convertAgreementType2DOMElement(def.getTagQName(), (com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.AgreementType) ((AbstractSchemaElementImpl) def)
                                .getModel());
                if(def.getDocumentBaseURI() != null) {
                	doc.setDocumentURI(def.getDocumentBaseURI().getPath());
                }
        }
        return doc;
    }

    public boolean getFeature(final String name) throws IllegalArgumentException {
        throw new NotImplementedException();
    }

    public void setFeature(final String name, final boolean value) throws IllegalArgumentException {
        throw new NotImplementedException();
    }

    public String writeAgreement(final Agreement def) throws WSAgreementException {
        String res = null;
        if ((def != null)
                && (def instanceof Agreement)) {
                res = WSAgreementWriterImpl
                        .convertAgreementType2String((com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.AgreementType) ((AbstractSchemaElementImpl) def)
                                .getModel());
            
        }
        return res;
    }

}
