package com.ebmwebsourcing.agreement.definition.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;


public interface AgreementLifeCycle {

	public enum State {
		OFFER_RECEIVE("OfferReceive"), REJECTE("Rejecte"), PENDING("Pending"), OBSERVE("Observe"), COMPLETE("Complete"), 
		PENDING_AND_TERMINATING("PendingAndTerminating"), OBSERVED_AND_TERMINATING("ObservedAndTerminating"), TERMINATE("Terminate");

		private final String value;


		private State(final String value) {
			this.value = value;
		}


		public String value() {
			return this.value;
		}


		public boolean equals(final String val) {
			return this.value().equals(val);
		}

		@Override
		public String toString() {
			return this.value;
		}

		public static State fromValue(String value) {
			State res = null;
			if(value != null) {
				for(State state: State.values()) {
					if(value.equals(state.value)) {
						res = state;
						break;
					}
				}
			}
			return res;
		}
	}

	State getState();

	void setState(State state);
}
