package com.ebmwebsourcing.agreement.definition.impl;

import java.math.BigInteger;
import java.util.Calendar;
import java.util.logging.Logger;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.CompensationType;

import com.ebmwebsourcing.agreement.definition.api.Compensation;
import com.ebmwebsourcing.agreement.definition.api.WSAgreementException;

public class CompensationImpl extends AbstractSchemaElementImpl<com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.CompensationType> implements Compensation {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private Logger log = Logger.getLogger(CompensationImpl.class.getName());

	

	public CompensationImpl(
			final com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.CompensationType model,
			final AbstractSchemaElementImpl parent)
	throws WSAgreementException {
		super(model, parent);
	}



	public Integer getCount() {
		Integer res = null;
		if((this.model.getAssessmentInterval() != null)&&(this.model.getAssessmentInterval().getCount() != null)) {
			res = this.model.getAssessmentInterval().getCount().intValue();
		}
		return res;
	}



	public Long getTimeInterval() {
		Long res = null;
		if((this.model.getAssessmentInterval() != null)&&(this.model.getAssessmentInterval().getTimeInterval() != null)) {
			res = this.model.getAssessmentInterval().getTimeInterval().getTimeInMillis(Calendar.getInstance());
		}
		return res;
	}



	public String getValueExpr() {
		return (String) this.model.getValueExpression();
	}



	public String getValueUnit() {
		return this.model.getValueUnit();
	}


	public void setCount(Integer count) {
		if(this.model.getAssessmentInterval() == null) {
			this.model.setAssessmentInterval(new CompensationType.AssessmentInterval());
		}
		this.model.getAssessmentInterval().setCount(BigInteger.valueOf(count));
	}


	public void setTimeInterval(Long time) throws WSAgreementException {
		try {
			if(this.model.getAssessmentInterval() == null) {
				this.model.setAssessmentInterval(new CompensationType.AssessmentInterval());
			}
			this.model.getAssessmentInterval().setTimeInterval(DatatypeFactory.newInstance().newDuration(time));
		} catch (DatatypeConfigurationException e) {
			throw new WSAgreementException(e);
		}
	}


	public void setValueExpr(String value) {
		this.model.setValueExpression(value);
	}



	public void setValueUnit(String value) {
		this.model.setValueUnit(value);
	}

}
