/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.agreement.definition.impl;

import com.ebmwebsourcing.agreement.definition.api.Agreement;
import com.ebmwebsourcing.agreement.definition.api.WSAgreementException;
import com.ebmwebsourcing.agreement.definition.api.WSAgreementReader;
import com.ebmwebsourcing.agreement.definition.impl.AgreementImpl;
import com.ebmwebsourcing.agreement.definition.impl.AgreementTemplateImpl;
import com.ebmwebsourcing.agreement.definition.impl.AgreementTypeImpl;
import com.ebmwebsourcing.agreement.definition.impl.WSAgreementJAXBContext;
import com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.AgreementTemplateType;
import com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.AgreementType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.schema.util.SourceHelper;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class WSAgreementReaderImpl
implements WSAgreementReader {
    private static Logger log = Logger.getLogger(WSAgreementReaderImpl.class.getName());

    public WSAgreementReaderImpl() throws WSAgreementException {
        WSAgreementJAXBContext.getInstance();
    }

    @Override
    public Agreement read(URL url) throws WSAgreementException {
        if (url == null) {
            throw new WSAgreementException("url cannot be null!!!");
        }
        Agreement desc = null;
        try {
            InputStream input = null;
            File f = new File(url.toURI().getPath());
            input = f.exists() ? new FileInputStream(f) : url.openStream();
            desc = this.read(url.toURI(), new InputSource(input));
        }
        catch (MalformedURLException e) {
            throw new WSAgreementException("Can not get agreement at: " + url, e);
        }
        catch (IOException e) {
            throw new WSAgreementException("Can not get agreement at: " + url, e);
        }
        catch (SchemaException e) {
            throw new WSAgreementException("Can not get agreement at: " + url, e);
        }
        catch (URISyntaxException e) {
            throw new WSAgreementException("Can not get agreement at: " + url, e);
        }
        return desc;
    }

    @Override
    public Agreement read(Document document) throws WSAgreementException {
        if (document == null) {
            throw new WSAgreementException("document cannot be null!!!");
        }
        Agreement desc = null;
        try {
            URI uri = null;
            uri = document.getDocumentURI() != null ? URI.create(document.getDocumentURI()) : URI.create(".");
            desc = this.read(uri, SourceHelper.convertDOMSource2InputSource((DOMSource)new DOMSource(document)));
        }
        catch (XmlException e) {
            throw new WSAgreementException(e);
        }
        return desc;
    }

    private Agreement read(URI uri, InputSource input) throws WSAgreementException {
        AgreementTypeImpl desc = null;
        try {
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            SAXSource saxSource = new SAXSource(xmlReader, input);
            JAXBElement agBinding = WSAgreementJAXBContext.getInstance().getJaxbContext().createUnmarshaller().unmarshal((Source)saxSource, AgreementTemplateType.class);
            desc = ((AgreementTemplateType)agBinding.getValue()).getTemplateId() != null ? new AgreementTemplateImpl(uri, (AgreementTemplateType)agBinding.getValue()) : new AgreementImpl(uri, (AgreementType)agBinding.getValue());
        }
        catch (XmlException e) {
            throw new WSAgreementException(e);
        }
        catch (SAXException e) {
            throw new WSAgreementException(e);
        }
        catch (JAXBException e) {
            throw new WSAgreementException(e);
        }
        return desc;
    }

    @Override
    public Agreement read(InputSource source) throws WSAgreementException {
        return this.read(URI.create("."), source);
    }
}

