package com.ebmwebsourcing.wsstar.dm.impl.expression;

import java.math.BigInteger;
import java.util.Date;
import java.util.GregorianCalendar;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;

import org.apache.commons.lang.NotImplementedException;
import org.w3c.dom.Element;

import com.ebmwebsourcing.wsstar.dm.api.WSDMException;
import com.ebmwebsourcing.wsstar.dm.api.expression.QoSInteger;
import com.ebmwebsourcing.wsstar.dm.impl.WSDMElementImpl;
import com.ebmwebsourcing.wsstar.dm.org.oasis_open.docs.wsdm.mows_2.IntegerCounter;

public class QoSIntegerImpl extends QosExpressionImpl<IntegerCounter, Integer> implements QoSInteger {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public QoSIntegerImpl(final IntegerCounter model, final WSDMElementImpl parent) {
		super(model, parent);
	}

	public Integer getValue() {
		Integer res = null;
		if (this.model.getValue() != null) {
			res = this.model.getValue().intValue();
		}
		return res;
	}

	public void setValue(final Integer value) {
		if (value != null) {
			this.model.setValue(BigInteger.valueOf(value));
		} else {
			this.model.setValue(null);
		}
	}

	public Duration getDuration() {
		return this.model.getDuration();
	}

	public Date getLastUpdated() {
		Date res = null;
		if (this.model.getLastUpdated() != null) {
			res = this.model.getLastUpdated().toGregorianCalendar().getTime();
		}
		return res;
	}

	public Date getResetAt() {
		Date res = null;
		if (this.model.getResetAt() != null) {
			res = this.model.getResetAt().toGregorianCalendar().getTime();
		}
		return res;
	}

	public void setDuration(final Duration d) {
		this.model.setDuration(d);
	}

	public void setLastUpdated(final Date d) throws WSDMException {
		if (d != null) {
			try {
				final GregorianCalendar gCalendar = new GregorianCalendar();
				gCalendar.setTime(d);

				final XMLGregorianCalendar xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gCalendar);

				this.model.setLastUpdated(xmlCalendar);
			} catch (final DatatypeConfigurationException e) {
				throw new WSDMException(e);
			}
		}
	}

	public void setResetAt(final Date d) throws WSDMException {
		if (d != null) {
			try {
				final GregorianCalendar gCalendar = new GregorianCalendar();
				gCalendar.setTime(d);

				final XMLGregorianCalendar xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gCalendar);

				this.model.setResetAt(xmlCalendar);
			} catch (final DatatypeConfigurationException e) {
				throw new WSDMException(e);
			}
		}
	}

	public void setAll(final QoSInteger qint) throws WSDMException {
		this.setDuration(qint.getDuration());
		this.setLastUpdated(qint.getLastUpdated());
		this.setResetAt(qint.getResetAt());
		this.setValue(qint.getValue());
	}

	public void addOtherElements(final Element arg0) {
		throw new NotImplementedException();
	}

}
