/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.wsstar.dm;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;

import javax.xml.namespace.QName;

import org.ow2.easywsdl.wsdl.WSDLFactory;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.w3c.dom.Document;

import com.ebmwebsourcing.wsstar.dm.api.QoSMetrics;
import com.ebmwebsourcing.wsstar.dm.api.WSDMDescription;
import com.ebmwebsourcing.wsstar.dm.api.WSDMException;
import com.ebmwebsourcing.wsstar.dm.api.WSDMReader;
import com.ebmwebsourcing.wsstar.dm.api.WSDMWriter;
import com.ebmwebsourcing.wsstar.dm.api.expression.QoSDuration;
import com.ebmwebsourcing.wsstar.dm.api.expression.QoSInteger;
import com.ebmwebsourcing.wsstar.dm.impl.QoSMetricsImpl;
import com.ebmwebsourcing.wsstar.dm.impl.WSDMDescriptionImpl;
import com.ebmwebsourcing.wsstar.dm.impl.WSDMReaderImpl;
import com.ebmwebsourcing.wsstar.dm.impl.WSDMWriterImpl;
import com.ebmwebsourcing.wsstar.dm.impl.expression.QoSDurationImpl;
import com.ebmwebsourcing.wsstar.dm.impl.expression.QoSIntegerImpl;
import com.ebmwebsourcing.wsstar.dm.org.oasis_open.docs.wsdm.mows_2.DurationMetric;
import com.ebmwebsourcing.wsstar.dm.org.oasis_open.docs.wsdm.mows_2.IntegerCounter;
import com.ebmwebsourcing.wsstar.dm.org.oasis_open.docs.wsdm.mows_2.OperationMetricType;

/**
 * This class is a concrete implementation of the abstract class WSDMFactory. Some ideas used here have been shamelessly copied from the wonderful JAXP and Xerces work.
 * 
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class WSDMFactoryImpl extends WSDMFactory {

	/**
	 * Create a new instance of a WSDLReaderImpl.
	 * 
	 * @throws WSDMException
	 */
	@Override
	public WSDMReader newWSDMReader() throws WSDMException {
		final WSDMReader reader = new WSDMReaderImpl();
		return reader;
	}

	/**
	 * Create a new instance of a WSDLWriterImpl.
	 * 
	 * @throws WSDMException
	 */
	@Override
	public WSDMWriter newWSDMWriter() throws WSDMException {
		final WSDMWriter writer = new WSDMWriterImpl();
		return writer;
	}

	@Override
	public QoSMetrics newQoSMetrics() throws WSDMException {
		return new QoSMetricsImpl(new OperationMetricType());
	}

	@Override
	public QoSDuration newQoSDuration() throws WSDMException {
		return new QoSDurationImpl(new DurationMetric(), null);
	}

	@Override
	public QoSInteger newQoSInteger() throws WSDMException {
		return new QoSIntegerImpl(new IntegerCounter(), null);
	}

	@Override
	public Document createWSDMWSDL(final QName service, final String endpoint) throws WSDMException {
		final WSDMDescription wsdm = new WSDMDescriptionImpl(service, endpoint);
		return wsdm.getDocument();
	}

	@Override
	public Document addManageabilityReferencesInInterfaceOfEndpoint(final URL wsdl, final QName serviceName, final String endpoint) throws WSDMException {
		Document doc = null;
		try {
			final Description desc = WSDLFactory.newInstance().newWSDLReader().read(wsdl);
			doc = WSDMDescriptionImpl.addManageabilityReferencesInInterfaceOfEndpoint(desc, serviceName, endpoint);
		} catch (final WSDLException e) {
			throw new WSDMException(e);
		} catch (final IOException e) {
			throw new WSDMException(e);
		} catch (final URISyntaxException e) {
			throw new WSDMException(e);
		}
		return doc;
	}

}
