/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.wsstar.dm.impl;

import java.util.logging.Logger;

import org.apache.commons.lang.NotImplementedException;
import org.ow2.easywsdl.schema.api.Documentation;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractXMLElementImpl;

import com.ebmwebsourcing.wsstar.dm.api.WSDMElement;


/**
 * Abstract super class for all WSDL Elements, providing some basic
 * common functionality.
 */

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract class WSDMElementImpl<E> extends AbstractXMLElementImpl<E> implements WSDMElement {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    private static Logger log = Logger.getLogger(WSDMElementImpl.class.getName());


    protected Documentation documentation;

    public WSDMElementImpl(E model, WSDMElementImpl parent) {
        super(model, parent);
    }

    /**
     * Set the documentation for this document.
     *
     * @param docEl
     *            the documentation element
     */
    @SuppressWarnings("unchecked")
    public void setDocumentation(final Documentation doc) {
        this.documentation = doc;
    }

    /**
     * Get the documentation.
     *
     * @return the documentation element
     */
    public Documentation getDocumentation() {
        return this.documentation;
    }

    /**
     * Create the documentation element.
     *
     * @return the documentation element
     */
    public Documentation createDocumentation() {
        throw new NotImplementedException();
    }


    @Override
    public String toString() {
        return this.model.toString();
    }

    public E getModel() {
        return this.model;
    }
}
