/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.dm.convertor;

import com.ebmwebsourcing.addressing.addressing4agreement.monitoring.api.EndpointReferenceType;
import com.ebmwebsourcing.addressing.addressing4agreement.monitoring.api.MonitoringPropertiesType;
import com.ebmwebsourcing.addressing.addressing4agreement.monitoring.api.ReferenceParametersType;
import com.ebmwebsourcing.addressing.addressing4agreement.monitoring.impl.WSAddressing4AgreementFactory;
import com.ebmwebsourcing.agreement.definition.api.Location;
import com.ebmwebsourcing.agreement.definition.api.Variable;
import com.ebmwebsourcing.agreement.definition.api.WSAgreementException;
import com.ebmwebsourcing.agreement.definition.impl.VariableImpl;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.addressing.definition.api.absitf.AbsItfReferenceParametersType;
import com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.VariableType;
import com.ebmwebsourcing.wsstar.agreement.service.api.MonitoringConvertor;
import com.ebmwebsourcing.wsstar.qml.WSQMLFactory;
import com.ebmwebsourcing.wsstar.qml.api.QOSDimension;
import com.ebmwebsourcing.wsstar.qml.api.WSQMLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class AgreementConvertor
implements MonitoringConvertor {
    private static List<Variable> variables = new ArrayList<Variable>();

    AgreementConvertor() throws WSAgreementException {
        variables.add(this.createLatencyVariable());
        variables.add(this.createAvailabilityVariable());
    }

    public List<Variable> convertMonitoringInformationsToVariableProperties() throws WSAgreementException {
        return variables;
    }

    private Variable createLatencyVariable() throws WSAgreementException {
        VariableImpl latency = null;
        try {
            latency = new VariableImpl(new VariableType(), null);
            latency.setName("latency");
            latency.setMetric(new URI("http://purl.oclc.org/NET/muo/ucum/unit/time/second"));
            Location location = latency.newLocation();
            latency.setLocation(location);
            EndpointReferenceType address = WSAddressing4AgreementFactory.newInstance().newEndpointReferenceType();
            address.setAddress("");
            location.setAddress(address);
            ReferenceParametersType ref = (ReferenceParametersType)address.newReferenceParameters();
            address.setReferenceParameters((AbsItfReferenceParametersType)ref);
            MonitoringPropertiesType monprops = ref.newMonitoringPropertiesType();
            ref.setMonitoringPropertiesType(monprops);
            Properties properties = new Properties();
            properties.put("mode", "pull");
            properties.put("operation", "speed");
            monprops.setProperty(properties);
            QOSDimension dim = WSQMLFactory.newInstance().newQOSDimension();
            dim.setSemanticConcept("http://www-rocq.inria.fr/arles/semeuse/SemeuseQoSOntology/QoSServiceOntology.owl#ResponseTime");
            location.setQOSDimension(dim);
        }
        catch (URISyntaxException e) {
            throw new WSAgreementException((Throwable)e);
        }
        catch (WSAddressingException e) {
            throw new WSAgreementException((Throwable)e);
        }
        catch (WSQMLException e) {
            throw new WSAgreementException((Throwable)e);
        }
        return latency;
    }

    private Variable createAvailabilityVariable() throws WSAgreementException {
        VariableImpl availability = null;
        try {
            availability = new VariableImpl(new VariableType(), null);
            availability.setName("availability");
            availability.setMetric(new URI("http://purl.oclc.org/NET/muo/ucum/unit/fraction/percent"));
            Location location = availability.newLocation();
            availability.setLocation(location);
            EndpointReferenceType address = WSAddressing4AgreementFactory.newInstance().newEndpointReferenceType();
            address.setAddress("");
            location.setAddress(address);
            ReferenceParametersType ref = (ReferenceParametersType)address.newReferenceParameters();
            address.setReferenceParameters((AbsItfReferenceParametersType)ref);
            MonitoringPropertiesType monprops = ref.newMonitoringPropertiesType();
            ref.setMonitoringPropertiesType(monprops);
            Properties properties = new Properties();
            properties.put("mode", "pull");
            properties.put("operation", "speed");
            monprops.setProperty(properties);
            QOSDimension dim = WSQMLFactory.newInstance().newQOSDimension();
            dim.setSemanticConcept("http://www-rocq.inria.fr/arles/semeuse/SemeuseQoSOntology/QoSServiceOntology.owl#Availability");
            location.setQOSDimension(dim);
        }
        catch (URISyntaxException e) {
            throw new WSAgreementException((Throwable)e);
        }
        catch (WSAddressingException e) {
            throw new WSAgreementException((Throwable)e);
        }
        catch (WSQMLException e) {
            throw new WSAgreementException((Throwable)e);
        }
        return availability;
    }
}

