/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.w3c.dom.Element;

import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.addressing.definition.impl.EndpointReferenceTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.utils.JaxbTypeConvertor;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;

public class SubscribeResponseImpl extends AbstractSchemaElementImpl<com.ebmwebsourcing.wsstar.notification.definition.base.SubscribeResponse> implements
SubscribeResponse {

	private static final long serialVersionUID = 1L;

	private EndpointReferenceType eprSubscription = null;

	public SubscribeResponseImpl(final com.ebmwebsourcing.wsstar.notification.definition.base.SubscribeResponse model,
			final AbstractSchemaElementImpl<?> parent) throws WSNotificationException {
		super(model,parent);

		try {
			if (model.getSubscriptionReference() != null) {
				this.eprSubscription = new EndpointReferenceTypeImpl(model.getSubscriptionReference(),this);
			}
		} catch (final WSAddressingException e) {
			throw new WSNotificationException(e);
		}
	}

	public void addOtherElements(final Element elmt) {
		final List<Object> objFromModel = this.model.getAny();
		if (objFromModel != null) {
			this.model.getAny().add(elmt);
		}
	}

	public List<Element> getOtherElements() throws XmlException {
		final List<Object> objFromModel = this.model.getAny();
		return objFromModel != null? JaxbTypeConvertor.JaxbObjectListToElementList(this.model.getAny()) : null;
	}

	public Date getCurrentTime() {
		final XMLGregorianCalendar objFromModel = this.model.getCurrentTime();
		return objFromModel!= null? objFromModel.toGregorianCalendar().getTime() : null;
	}

	public EndpointReferenceType getSubscriptionReference() throws WSNotificationException {
		return this.eprSubscription;
		/*
		EndpointReferenceType ref;
		ref = WSNotificationFactory.getInstance().createEndpointReferenceType();
		ref.setAddress(this.model.getSubscriptionReference().getAddress().getValue());
		return ref;
		 */
	}

	public Date getTerminationTime() {
		final XMLGregorianCalendar objFromModel = this.model.getTerminationTime();
		return objFromModel!= null? objFromModel.toGregorianCalendar().getTime() : null;
	}

	public void setCurrentTime(final Date value) throws WSNotificationException {
		final GregorianCalendar gCalendar = new GregorianCalendar();
		gCalendar.setTime(value);
		XMLGregorianCalendar xmlCalendar;

		try {
			xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gCalendar);
			this.model.setCurrentTime(xmlCalendar);
		} catch (final DatatypeConfigurationException e) {
			throw new WSNotificationException(e);
		}
	}

	public void setSubscriptionReference(final EndpointReferenceType ref) {
		((AbstractSchemaElementImpl)ref).setParent(this);
		this.eprSubscription = ref;
		this.model.setSubscriptionReference((com.ebmwebsourcing.wsstar.addressing.definition.org.w3._2005._08.addressing.EndpointReferenceType) ((AbstractSchemaElementImpl<?>)ref).getModel());
	}

	public void setTerminationTime(final Date value) throws WSNotificationException {

		final GregorianCalendar gCalendar = new GregorianCalendar();
		gCalendar.setTime(value);
		XMLGregorianCalendar xmlCalendar;
		try {
			xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gCalendar);
			this.model.setTerminationTime(xmlCalendar);
		} catch (final DatatypeConfigurationException e) {
			throw new WSNotificationException(e);
		}
	}

}
