/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.definition.brokerednotification;

import javax.xml.namespace.QName;

/**
 * Constants of WS-BrokeredNotification 
 * 
 * @author Thierry Déjean -eBM Websourcing
 */
public class WsnbrConstants {
	// ============== Namespaces and URIs constants (Only those not already defined in WS-BaseNotification) ============
	
	public static final String WS_BROKERED_NOTIFICATION_NAMESPACE_URI = "http://docs.oasis-open.org/wsn/br-2";

    public static final String WS_BROKERED_NOTIFICATION_PREFIX = "wsn-br";
    
    // =================================================================================================================    
    
    // =============== Operations QNAME Constants (Only those not already defined in WS-BaseNotification) ==============
    
    public static final String DESTROY_REGISTRATION_NAME = "DestroyRegistration";    
    public static final QName DESTROY_REGISTRATION_QNAME = new QName(WS_BROKERED_NOTIFICATION_NAMESPACE_URI, DESTROY_REGISTRATION_NAME,
            WS_BROKERED_NOTIFICATION_PREFIX);
    
    public static final String DESTROY_REGISTRATION_RESPONSE_NAME = "DestroyRegistrationResponse";
    public static final QName DESTROY_REGISTRATION_RESPONSE_QNAME = new QName(WS_BROKERED_NOTIFICATION_NAMESPACE_URI, DESTROY_REGISTRATION_RESPONSE_NAME,
            WS_BROKERED_NOTIFICATION_PREFIX);    
   
    public static final String REGISTER_PUBLISHER_NAME = "RegisterPublisher";
    public static final QName REGISTER_PUBLISHER_QNAME = new QName(WS_BROKERED_NOTIFICATION_NAMESPACE_URI, "RegisterPublisher",
            WS_BROKERED_NOTIFICATION_PREFIX);
        
    public static final String REGISTER_PUBLISHER_RESPONSE_NAME = "RegisterPublisherResponse";
    public static final QName REGISTER_PUBLISHER_RESPONSE_QNAME = new QName(WS_BROKERED_NOTIFICATION_NAMESPACE_URI, REGISTER_PUBLISHER_RESPONSE_NAME,
            WS_BROKERED_NOTIFICATION_PREFIX);
    // ==================================================================================================================
    
    // =================== Type QNAME constants =========================
    public static final String PUBLISHER_REGISTRATION_REFERENCE_NAME = "PublisherRegistrationReference";
     public static final QName PUBLISHER_REGISTRATION_REFERENCE_QNAME = new QName (WS_BROKERED_NOTIFICATION_NAMESPACE_URI, PUBLISHER_REGISTRATION_REFERENCE_NAME,
    		 WS_BROKERED_NOTIFICATION_PREFIX);
    
    public static final String TOPIC_NAME = "Topic";
    public static final QName TOPIC_QNAME = new QName(WS_BROKERED_NOTIFICATION_NAMESPACE_URI, TOPIC_NAME,
            WS_BROKERED_NOTIFICATION_PREFIX);
    
    public static final String PUBLISHER_SUBSCRIPTION_MANAGER_REFERENCE_NAME = "PublisherSubscriptionManagerReference";
    public static final QName PUBLISHER_SUBSCRIPTION_MANAGER_REFERENCE_QNAME = new QName (PUBLISHER_SUBSCRIPTION_MANAGER_REFERENCE_NAME);
   
    // ==================================================================
    
    // ==================== Faults QNAME Constants (Only those not already defined in WS-BaseNotification) ==============
    public static final String PUBLISHER_REGISTRATION_REJECTED_NAME = "PublisherRegistrationRejectedFault";
    public static final QName PUBLISHER_REGISTRATION_REJECTED_QNAME = new QName(
            WS_BROKERED_NOTIFICATION_NAMESPACE_URI, PUBLISHER_REGISTRATION_REJECTED_NAME , WS_BROKERED_NOTIFICATION_PREFIX);

    public static final String PUBLISHER_REGISTRATION_FAILED_NAME = "PublisherRegistrationFailedFault";
    public static final QName PUBLISHER_REGISTRATION_FAILED_QNAME = new QName(
            WS_BROKERED_NOTIFICATION_NAMESPACE_URI, PUBLISHER_REGISTRATION_FAILED_NAME , WS_BROKERED_NOTIFICATION_PREFIX);        
    
    public static final String RESOURCE_NOT_DESTROYED_NAME = "ResourceNotDestroyedFault";
    public static final QName RESOURCE_NOT_DESTROYED_QNAME = new QName(
            WS_BROKERED_NOTIFICATION_NAMESPACE_URI, RESOURCE_NOT_DESTROYED_NAME, WS_BROKERED_NOTIFICATION_PREFIX);        
        
    // ===================================================================================================================   
}
