/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.definition.inout;

import org.w3c.dom.Document;

import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Notify;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.QueryExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Subscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.TopicExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Unsubscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnsubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistration;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistrationResponse;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisher;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisherResponse;
import com.ebmwebsourcing.wsstar.notification.definition.topics.api.TopicNamespaceType;
import com.ebmwebsourcing.wsstar.notification.definition.topics.api.TopicSetType;
import com.ebmwebsourcing.wsstar.notification.definition.topics.api.TopicType;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;

/**
 * This interface describes a collection of methods that enable conversion of a
 * {@link Document} object into a "WS-{Base/Brokered}Notification java type" object.
 * This conversion uses JAXB "unmarshalling" mechanism
 * 
 * @author Thierry Déjean - eBM WebSourcing
 */
public interface WSNotificationReader {

    /**
     * Unmarshall {@link RegisterPublisher} object from a {@link Document} representation fragment object 
     * 
     * @param doc {@link org.w3c.dom.Document} object representation of {@link RegisterPublisher} Java type 
     * @return a {@link RegisterPublisher} object (type generated with jaxb tools) 
     * @throws WSNotificationException
     */
    public RegisterPublisher readRegisterPublisher(final Document doc) throws WSNotificationException;
    
    /**
     * Unmarshall {@link RegisterPublisherResponse} object from a {@link Document} representation fragment object 
     * 
     * @param doc {@link org.w3c.dom.Document} object representation of {@link RegisterPublisherResponse} Java type 
     * @return a {@link RegisterPublisherResponse} object (type generated with jaxb tools) 
     * @throws WSNotificationException
     */
    public RegisterPublisherResponse readRegisterPublisherResponse(final Document doc) throws WSNotificationException;
    
    /**
     * Unmarshall {@link DestroyRegistration} object from a {@link Document} representation fragment object 
     *  
     * @param doc {@link org.w3c.dom.Document} object representation of {@link DestroyRegistration} Java type
     * @return a {@link DestroyRegistration} object (type generated with jaxb tools)
     * @throws WSNotificationException
     */
    public DestroyRegistration readDestroyRegistration(final Document doc) throws WSNotificationException;
    

    /**
     * Unmarshall {@link DestroyRegistrationResponse} object from a {@link Document} representation fragment object 
     *  
     * @param doc {@link org.w3c.dom.Document} object representation of {@link DestroyRegistrationResponse} Java type
     * @return a {@link DestroyRegistrationResponse} object (type generated with jaxb tools)
     * @throws WSNotificationException
     */
    public DestroyRegistrationResponse readDestroyRegistrationResponse(final Document doc) throws WSNotificationException;
    
    
    /**
     * Unmarshall {@link Subscribe} object from a {@link Document} representation fragment object 
     * 
     * @param doc {@link org.w3c.dom.Document} object representation of {@link Subscribe} Java type 
     * @return a {@link Subscribe} object (type generated with jaxb tools) 
     * @throws WSNotificationException
     */
    public Subscribe readSubscribe(final Document doc) throws WSNotificationException;
    
    /**
     * Unmarshall {@link SubscribeResponse} object from a {@link Document} representation fragment object 
     * 
     * @param doc {@link org.w3c.dom.Document} object representation of {@link SubscribeResponse} Java type 
     * @return a {@link SubscribeResponse} object (type generated with jaxb tools) 
     * @throws WSNotificationException
     */
    public SubscribeResponse readSubscribeResponse(final Document doc) throws WSNotificationException;
    
    
    /**
     *  Unmarshall {@link Unsubscribe} object from a {@link Document} representation fragment object 
     * 
     * @param doc {@link org.w3c.dom.Document} object representation of {@link Unsubscribe} Java type
     * @return a {@link Unsubscribe} object (type generated with jaxb tools) 
     * @throws WSNotificationException
     */
    public Unsubscribe readUnsubscribe(final Document doc) throws WSNotificationException; 
    
    /**
     *  Unmarshall {@link UnsubscribeResponse} object from a {@link Document} representation fragment object 
     * 
     * @param doc org.w3c.dom.Document object representation of {@link UnsubscribeResponse} Java type
     * @return a {@link UnsubscribeResponse} object (type generated with jaxb tools) 
     * @throws WSNotificationException
     */
    public UnsubscribeResponse readUnsubscribeResponse(final Document doc) throws WSNotificationException; 
    
    
    /**
     * Unmarshall {@link Notify} object from a {@link Document} representation fragment object 
     * 
     * @param doc {@link org.w3c.dom.Document} object representation of {@link Notify} Java type
     * @return a {@link Notify} object (type generated with jaxb tools) 
     * @throws WSNotificationException
     */    
    public Notify readNotify(final Document doc) throws WSNotificationException;
    
    /**
     * Unmarshall {@link EndpointReferenceType} object from a {@link Document} representation fragment object 
     * 
     * @param doc {@link org.w3c.dom.Document} object representation of {@link EndpointReferenceType} Java type
     * @return a {@link EndpointReferenceType} object (type generated with jaxb tools)
     * @throws WSNotificationException
     */
    
    /**
     * Unmarshall {@link TopicExpressionType} object from a {@link Document} representation fragment object 
     * 
     * @param doc {@link org.w3c.dom.Document} object representation of {@link TopicExpressionType} Java type
     * @return a {@link TopicExpressionType} object (type generated with jaxb tools)
     * @throws WSNotificationException
     */
    public TopicExpressionType readTopicExpressionType(final Document doc) throws WSNotificationException;
    
    /**
     * Unmarshall {@link QueryExpressionType} object from a {@link Document} representation fragment object 
     * 
     * @param doc {@link org.w3c.dom.Document} object representation of {@link QueryExpressionType} Java type
     * @return a {@link QueryExpressionType} object (type generated with jaxb tools)
     * @throws WSNotificationException
     */
    public QueryExpressionType readQueryExpressionType(final Document doc) throws WSNotificationException;
    
    /**
     * Unmarshall {@link TopicType} object from a {@link Document} representation fragment object 
     * 
     * @param doc {@link org.w3c.dom.Document} object representation of {@link TopicType} Java type
     * @return a {@link TopicType} object (type generated with jaxb tools)
     * @throws WSNotificationException
     */
    public TopicType readTopicType(final Document doc) throws WSNotificationException;
    
    /**
     * Unmarshall {@link TopicNamespaceType} object from a {@link Document} representation fragment object 
     * 
     * @param doc {@link org.w3c.dom.Document} object representation of {@link TopicNamespaceType} Java type
     * @return a {@link TopicNamespaceType} object (type generated with jaxb tools)
     * @throws WSNotificationException
     */
    public TopicNamespaceType readTopicNamespaceType(final Document doc) throws WSNotificationException;
    
    /**
     * Unmarshall {@link TopicSetType} object from a {@link Document} representation fragment object 
     * 
     * @param doc {@link org.w3c.dom.Document} object representation of {@link TopicSetType} Java type
     * @return a {@link TopicSetType} object (type generated with jaxb tools)
     * @throws WSNotificationException
     */
    public TopicSetType readTopicSetType(final Document doc) throws WSNotificationException;
    
}
