/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.wsstar.notification.definition;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

import com.ebmwebsourcing.wsstar.notification.definition.basefaults.api.BaseFaultDescriptionType;
import com.ebmwebsourcing.wsstar.notification.definition.basefaults.api.BaseFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.FilterType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.GetCurrentMessage;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.GetCurrentMessageResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.InvalidFilterFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.InvalidMessageContentExpressionFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.InvalidProducerPropertiesExpressionFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.InvalidTopicExpressionFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Message;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.MultipleTopicsSpecifiedFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.NoCurrentMessageOnTopicFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Notify;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.NotifyMessageNotSupportedFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.PauseFailedFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.QueryExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Renew;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.RenewResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.ResumeFailedFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Subscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscribeCreationFailedFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscriptionManagerRP;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscriptionPolicyType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.TopicExpressionDialectUnknownFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.TopicExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.TopicNotSupportedFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnableToCreatePullPointFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnableToDestroyPullPointFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnableToDestroySubscriptionFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnableToGetMessagesFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnacceptableInitialTerminationTimeFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnacceptableTerminationTimeFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnrecognizedPolicyRequestFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Unsubscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnsubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnsupportedPolicyRequestFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistration;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistrationResponse;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.PublisherRegistrationFailedFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.PublisherRegistrationRP;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.PublisherRegistrationRejectedFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisher;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisherResponse;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.ResourceNotDestroyedFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.inout.WSNotificationReader;
import com.ebmwebsourcing.wsstar.notification.definition.inout.WSNotificationWriter;
import com.ebmwebsourcing.wsstar.notification.definition.resource.api.ResourceUnknownFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.topics.api.TopicNamespaceType;
import com.ebmwebsourcing.wsstar.notification.definition.topics.api.TopicType;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;

/**
 * This abstract class defines a factory API that enables applications
 * to obtain a Factory capable of producing new Definitions, new Reader,
 * and new Writer.
 * 
 * Note : This class is implemented respect to the "Singleton design pattern".
 *    The solution of Bill Pugh - University of Maryland - has been used, because
 *    it supposed to be "thread-safe" without requiring special language constructs
 *    (i.e. volatile or synchronized). For more details, see :
 *    
 *     http://en.wikipedia.org/wiki/Singleton_pattern
 * 
 * @author Thierry Déjean - eBM WebSourcing
 */
public abstract class WSNotificationFactory {

	protected com.ebmwebsourcing.wsstar.notification.definition.base.ObjectFactory wsnbFactory;
	protected com.ebmwebsourcing.wsstar.notification.definition.brokered.ObjectFactory wsnbrFactory;
	protected com.ebmwebsourcing.wsstar.notification.definition.topics.ObjectFactory wstopFactory;
	protected com.ebmwebsourcing.wsstar.notification.definition.resource.basefaults.ObjectFactory wsrfbfFactory;
	protected com.ebmwebsourcing.wsstar.notification.definition.resource.ObjectFactory wsrfrwFactory;
    	
	// Protected constructor is sufficient to suppress unauthorized calls to the constructor
	protected WSNotificationFactory() {
		this.wstopFactory = new com.ebmwebsourcing.wsstar.notification.definition.topics.ObjectFactory();
		this.wsnbFactory = new com.ebmwebsourcing.wsstar.notification.definition.base.ObjectFactory();
		this.wsnbrFactory = new com.ebmwebsourcing.wsstar.notification.definition.brokered.ObjectFactory();
		this.wsrfrwFactory = new com.ebmwebsourcing.wsstar.notification.definition.resource.ObjectFactory();
		this.wsrfbfFactory = new com.ebmwebsourcing.wsstar.notification.definition.resource.basefaults.ObjectFactory();
	}

	/**
	 * SingletonHolder is loaded on the first execution of Singleton.getInstance() 
	 * or the first access to SingletonHolder.INSTANCE, not before.
	 */
	private static class WSNotificationFactoryHolder { 
		private final static WSNotificationFactory INSTANCE = new WSNotificationFactoryImpl();
	}

	/**
	 * Return an unique - respect to the Singleton design pattern - instance  
	 * of the {@link WSNotificationFactory} class. Getting this object type is the first step to build
	 * all others "WS-Notification paradigm objects" and Reader/Writer objects.  
	 * 
	 * @return a unique WSNotificationFactory instance. 
	 */
	public static WSNotificationFactory getInstance() {
		return WSNotificationFactoryHolder.INSTANCE;
	}

	/**
	 * Create a {@link WSNotificationReader} object
	 * 
	 * @return a {@link WSNotificationReader} instance
	 * @throws WSNotificationException
	 */
	//public abstract WSNotificationReader createWSNotificationReader() throws WSNotificationException;
	
	/**
	 * Create a {@link WSNotificationWriter} object. The returned instance will used default "prefix/namespace
	 * mapping" during marshalling operation. See JAXB API documentation form more details  
	 * 
	 * @return a WSNotificationWriter instance
	 * @throws WSNotificationException
	 */
	//public abstract WSNotificationWriter createWSNotificationWriter() throws WSNotificationException;	   
	
	/**
	 * Create a {@link WSNotificationWriter} object. The returned instance will used custom "prefix/namespace
	 * mapping" during marshalling operation. See JAXB API documentation form more details  
	 * 
	 * @param namespacesAndPrefix the custom prefix/namespace mapping to use   
	 * @return a WSNotificationWriter instance 
	 * @throws WSNotificationException
	 */
	//public abstract WSNotificationWriter createWSNotificationWriter(String[] namespacesAndPrefix) throws WSNotificationException;

	/**
	 * an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
	 * The "conversion" from String to JAXBElement<Sting> is mandatory
	 * in order to marshalling mechanism don't fail
	 * 
	 * @param qname the QName part of the JAXBElement
	 * @param value the string value to "convert"
	 * @return a {@link JAXBElement }{@code <}{@link String }{@code >}} representation
	 */
	public abstract JAXBElement<String> createStringJaxbElt(QName qname,String value);

	/**
	 * create an instance of the {@link Subscribe} class 
	 * 
	 * @return a new {@link Subscribe} object
	 * @throws WSNotificationException
	 */
	public abstract Subscribe createSubscribe() throws WSNotificationException;

	/**
	 * create an instance of the {@link SubscribeResponse} class
	 * 
	 * @return a new {@link SubscribeResponse} object
	 * @throws WSNotificationException
	 */
	public abstract SubscribeResponse createSubscribeResponse() throws WSNotificationException;
	
	/**
	 * create an instance of the {@link GetCurrentMessage} class 
	 * 
	 * @return a new {@link GetCurrentMessage} object
	 * @throws WSNotificationException
	 */
	public abstract GetCurrentMessage createGetCurrentMessage() throws WSNotificationException;

	/**
	 * create an instance of the {@link GetCurrentMessageResponse} class
	 * 
	 * @return a new {@link GetCurrentMessageResponse} object
	 * @throws WSNotificationException
	 */
	public abstract GetCurrentMessageResponse createGetCurrentMessageResponse() throws WSNotificationException;
	
		
	
	/**
	 * create an instance of the {@link Unsubscribe} class
	 * 
	 * @return a new {@link Unsubscribe} object
	 * @throws WSNotificationException
	 */
	public abstract Unsubscribe createUnsubscribe() throws WSNotificationException;

	/**
	 * create an instance of the {@link UnsubscribeResponse} class
	 * 
	 * @return a new {@link UnsubscribeResponse}   
	 * @throws WSNotificationException
	 */
	public abstract UnsubscribeResponse createUnsubscribeResponse() throws WSNotificationException;
	
	/**
	 * create an instance of the {@link SubscriptionManagerRP} class
	 * 
	 * @return a new {@link SubscriptionManagerRP} object
	 * @throws WSNotificationException
	 */
	public abstract SubscriptionManagerRP createSubscriptionManagerRP() throws WSNotificationException;
	
	/**
	 * create an instance of the {@link Renew} class
	 * 
	 * @return a new {@link Renew} object
	 * @throws WSNotificationException
	 */
	public abstract Renew createRenew() throws WSNotificationException;

	/**
	 * create an instance of the {@link RenewResponse} class
	 * 
	 * @return a new {@link RenewResponse}   
	 * @throws WSNotificationException
	 */
	public abstract RenewResponse createRenewResponse() throws WSNotificationException;	

	/**
	 * create an instance of the {@link SubscriptionPolicyType} class
	 * 
	 * @return a new {@link SubscriptionPolicyType} object
	 * @throws WSNotificationException
	 */
    public abstract SubscriptionPolicyType createSubscriptionPolicyType() throws WSNotificationException;

	/**
	 * create an instance of the {@link Notify} class
	 * 
	 * @return a new {@link Notify} object
	 * @throws WSNotificationException
	 */
	public abstract Notify createNotify() throws WSNotificationException;

	/**
	 * create an instance of the {@link NotificationMessageHolderType} class
	 * 
	 * @return a new {@link NotificationMessageHolderType} object
	 * @throws WSNotificationException
	 */
    public abstract NotificationMessageHolderType createNotificationMessageHolderType() throws WSNotificationException;
    
    /**
	 * create an instance of the {@link SubscriptionManagerRP} class
	 * 
	 * @return a new {@link SubscriptionManagerRP} object
	 * @throws WSNotificationException
	 */
    public abstract Message createMessage() throws WSNotificationException;
    
	/**
	 * create an instance of the {@link TopicExpressionType} class
	 * 
	 * @return a new {@link TopicExpressionType} object
	 * @throws WSNotificationException
	 */
    public abstract TopicExpressionType createTopicExpressionType() throws WSNotificationException;
    
    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.base.TopicExpressionType }{@code >}}
     * 
     * @param value the {@link TopicExpressionType} object to "convert to" JAXBElement
     * @return a {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.base.TopicExpressionType }{@code >}} representation
     * @throws WSNotificationException
     */
    public abstract JAXBElement<?> createTopicExpressionType(TopicExpressionType value) throws WSNotificationException;
    
	/**
	 * create an instance of the {@link QueryExpressionType} class
	 * 
	 * @return a new {@link QueryExpressionType} object
	 * @throws WSNotificationException
	 */
    public abstract QueryExpressionType createQueryExpressionType() throws WSNotificationException;
    
    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.base.QueryExpressionType }{@code >}}
     * 
     * @param value the {@link QueryExpressionType} object to "convert to" JAXBElement
     * @return a {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.base.QueryExpressionType }{@code >}} representation
     * @throws WSNotificationException
     */
    public abstract JAXBElement<?> createMessageContent(QueryExpressionType value) throws WSNotificationException;
    
	/**
	 * create an instance of the {@link FilterType} class
	 * 
	 * @return a new {@link FilterType} object
	 * @throws WSNotificationException
	 */
    public abstract FilterType createFiltertype() throws WSNotificationException;
    
    // ~~~ WS-BaseNotification faults ~~~

	/**
	 * create an instance of the {@link InvalidFilterFaultType} class
	 * 
	 * @return a new {@link InvalidFilterFaultType} object
	 * @throws WSNotificationException
	 */
    public abstract InvalidFilterFaultType createInvalidFilterFaultType() throws WSNotificationException;
		
    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.base.InvalidFilterFaultType }{@code >}}
     * 
     * @param fault the {@link InvalidFilterFaultType} object to "convert to" JAXBElement
     * @return a {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.base.InvalidFilterFaultType }{@code >}} representation
     * @throws WSNotificationException
     */
    public abstract JAXBElement<?> createInvalidFilterFault(InvalidFilterFaultType fault) throws WSNotificationException;
    
	/**
	 * create an instance of the {@link InvalidMessageContentExpressionFaultType} class
	 * 
	 * @return a new {@link InvalidMessageContentExpressionFaultType} object
	 * @throws WSNotificationException
	 */
    public abstract InvalidMessageContentExpressionFaultType createInvalidMessageContentExpressionFaultType() throws WSNotificationException;
    
    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.base.InvalidMessageContentExpressionFaultType }{@code >}}
     * 
     * @param fault the {@link InvalidMessageContentExpressionFaultType} object to "convert to" JAXBElement
     * @return a {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.base.InvalidMessageContentExpressionFaultType }{@code >}} representation
     * @throws WSNotificationException
     */
    public abstract JAXBElement<?> createInvalidMessageContentExpressionFault(InvalidMessageContentExpressionFaultType fault) throws WSNotificationException;
    
	/**
	 * create an instance of the {@link InvalidProducerPropertiesExpressionFaultType} class
	 * 
	 * @return a new {@link InvalidProducerPropertiesExpressionFaultType} object
	 * @throws WSNotificationException
	 */
    public abstract InvalidProducerPropertiesExpressionFaultType createInvalidProducerPropertiesExpressionFaultType() throws WSNotificationException;
    
    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.base.InvalidProducerPropertiesExpressionFaultType }{@code >}}
     * 
     * @param fault the {@link InvalidProducerPropertiesExpressionFaultType} object to "convert to" JAXBElement
     * @return a {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.base.InvalidProducerPropertiesExpressionFaultType }{@code >}} representation
     * @throws WSNotificationException
     */
    public abstract JAXBElement<?> createInvalidProducerPropertiesExpressionFault(InvalidProducerPropertiesExpressionFaultType fault) throws WSNotificationException;
    
	/**
	 * create an instance of the {@link InvalidTopicExpressionFaultType} class
	 * 
	 * @return a new {@link InvalidTopicExpressionFaultType} object
	 * @throws WSNotificationException
	 */
    public abstract InvalidTopicExpressionFaultType createInvalidTopicExpressionFaultType() throws WSNotificationException;
    
    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.base.InvalidTopicExpressionFaultType }{@code >}}
     * 
     * @param fault the {@link InvalidTopicExpressionFaultType} object to "convert to" JAXBElement
     * @return a {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.base.InvalidTopicExpressionFaultType }{@code >}} representation
     * @throws WSNotificationException
     */
    public abstract JAXBElement<?> createInvalidTopicExpressionFault(InvalidTopicExpressionFaultType fault) throws WSNotificationException;
    
	/**
	 * create an instance of the {@link MultipleTopicsSpecifiedFaultType} class
	 * 
	 * @return a new {@link MultipleTopicsSpecifiedFaultType} object
	 * @throws WSNotificationException
	 */
    public abstract MultipleTopicsSpecifiedFaultType createMultipleTopicsSpecifiedFaultType() throws WSNotificationException;
    
    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.base.MultipleTopicsSpecifiedFaultType }{@code >}}
     * 
     * @param fault the {@link MultipleTopicsSpecifiedFaultType} object to "convert to" JAXBElement
     * @return a {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.base.MultipleTopicsSpecifiedFaultType }{@code >}} representation
     * @throws WSNotificationException
     */
    public abstract JAXBElement<?> createMultipleTopicsSpecifiedFault(MultipleTopicsSpecifiedFaultType fault) throws WSNotificationException;
    
	/**
	 * create an instance of the {@link NoCurrentMessageOnTopicFaultType} class
	 * 
	 * @return a new {@link NoCurrentMessageOnTopicFaultType} object
	 * @throws WSNotificationException
	 */
    public abstract NoCurrentMessageOnTopicFaultType createNoCurrentMessageOnTopicFaultType() throws WSNotificationException;
    
    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.base.NoCurrentMessageOnTopicFaultType }{@code >}}
     * 
     * @param fault the {@link NoCurrentMessageOnTopicFaultType} object to "convert to" JAXBElement
     * @return a {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.base.NoCurrentMessageOnTopicFaultType }{@code >}} representation
     * @throws WSNotificationException
     */
    public abstract JAXBElement<?> createNoCurrentMessageOnTopicFault(NoCurrentMessageOnTopicFaultType fault) throws WSNotificationException;
    
	/**
	 * create an instance of the {@link NotifyMessageNotSupportedFaultType} class
	 * 
	 * @return a new {@link NotifyMessageNotSupportedFaultType} object
	 * @throws WSNotificationException
	 */
    public abstract NotifyMessageNotSupportedFaultType createNotifyMessageNotSupportedFaultType() throws WSNotificationException;
    
    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.base.NotifyMessageNotSupportedFaultType }{@code >}}
     * 
     * @param fault the {@link NotifyMessageNotSupportedFaultType} object to "convert to" JAXBElement
     * @return a {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.base.NotifyMessageNotSupportedFaultType }{@code >}} representation
     * @throws WSNotificationException
     */
    public abstract JAXBElement<?> createNotifyMessageNotSupportedFault(NotifyMessageNotSupportedFaultType fault) throws WSNotificationException;
    
	/**
	 * create an instance of the {@link PauseFailedFaultType} class
	 * 
	 * @return a new {@link PauseFailedFaultType} object
	 * @throws WSNotificationException
	 */
    public abstract PauseFailedFaultType createPauseFailedFaultType() throws WSNotificationException;
    
    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.base.PauseFailedFaultType }{@code >}}
     * 
     * @param fault the {@link PauseFailedFaultType} object to "convert to" JAXBElement
     * @return a {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.brokered.PauseFailedFaultType }{@code >}} representation
     * @throws WSNotificationException
     */
    public abstract JAXBElement<?> createPauseFailedFault(PauseFailedFaultType fault) throws WSNotificationException;    
    
	/**
	 * create an instance of the {@link ResumeFailedFaultType} class
	 * 
	 * @return a new {@link ResumeFailedFaultType} object
	 * @throws WSNotificationException
	 */
    public abstract ResumeFailedFaultType createResumeFailedFaultType() throws WSNotificationException;
    
    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.base.ResumeFailedFaultType }{@code >}}
     * 
     * @param fault the {@link ResumeFailedFaultType} object to "convert to" JAXBElement
     * @return a {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.base.ResumeFailedFaultType }{@code >}} representation
     * @throws WSNotificationException
     */
    public abstract JAXBElement<?> createResumeFailedFault(ResumeFailedFaultType fault) throws WSNotificationException;    
    
	/**
	 * create an instance of the {@link SubscribeCreationFailedFaultType} class
	 * 
	 * @return a new {@link SubscribeCreationFailedFaultType} object
	 * @throws WSNotificationException
	 */
    public abstract SubscribeCreationFailedFaultType createSubscribeCreationFailedFaultType() throws WSNotificationException;
    
    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.base.SubscribeCreationFailedFaultType }{@code >}}
     * 
     * @param fault the {@link SubscribeCreationFailedFaultType} object to "convert to" JAXBElement
     * @return a {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.base.SubscribeCreationFailedFaultType }{@code >}} representation
     * @throws WSNotificationException
     */
    public abstract JAXBElement<?> createSubscribeCreationFailedFault(SubscribeCreationFailedFaultType fault) throws WSNotificationException;
    
	/**
	 * create an instance of the {@link TopicExpressionDialectUnknownFaultType} class
	 * 
	 * @return a new {@link TopicExpressionDialectUnknownFaultType} object
	 * @throws WSNotificationException
	 */
    public abstract TopicExpressionDialectUnknownFaultType createTopicExpressionDialectUnknownFaultType() throws WSNotificationException;
    
    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.base.TopicExpressionDialectUnknownFaultType }{@code >}}
     * 
     * @param fault the {@link TopicExpressionDialectUnknownFaultType} object to "convert to" JAXBElement
     * @return a {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.base.TopicExpressionDialectUnknownFaultType }{@code >}} representation
     * @throws WSNotificationException
     */
    public abstract JAXBElement<?> createTopicExpressionDialectUnknownFault(TopicExpressionDialectUnknownFaultType fault) throws WSNotificationException;
    
	/**
	 * create an instance of the {@link TopicNotSupportedFaultType} class
	 * 
	 * @return a new {@link TopicNotSupportedFaultType} object
	 * @throws WSNotificationException
	 */
    public abstract TopicNotSupportedFaultType createTopicNotSupportedFaultType() throws WSNotificationException;
    
    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.base.TopicNotSupportedFaultType }{@code >}}
     * 
     * @param fault the {@link TopicNotSupportedFaultType} object to "convert to" JAXBElement
     * @return a {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.base.TopicNotSupportedFaultType }{@code >}} representation
     * @throws WSNotificationException
     */
    public abstract JAXBElement<?> createTopicNotSupportedFault(TopicNotSupportedFaultType fault) throws WSNotificationException;
    
	/**
	 * create an instance of the {@link UnableToCreatePullPointFaultType} class
	 * 
	 * @return a new {@link UnableToCreatePullPointFaultType} object
	 * @throws WSNotificationException
	 */
    public abstract UnableToCreatePullPointFaultType createUnableToCreatePullPointFaultType() throws WSNotificationException;
    
    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.base.UnableToCreatePullPointFaultType }{@code >}}
     * 
     * @param fault the {@link UnableToCreatePullPointFaultType} object to "convert to" JAXBElement
     * @return a {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.base.UnableToCreatePullPointFaultType }{@code >}} representation
     * @throws WSNotificationException
     */
    public abstract JAXBElement<?> createUnableToCreatePullPointFault(UnableToCreatePullPointFaultType fault) throws WSNotificationException;
    
	/**
	 * create an instance of the {@link UnableToDestroyPullPointFaultType} class
	 * 
	 * @return a new {@link UnableToDestroyPullPointFaultType} object
	 * @throws WSNotificationException
	 */
    public abstract UnableToDestroyPullPointFaultType createUnableToDestroyPullPointFaultType() throws WSNotificationException;
    
    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link UnableToDestroyPullPointFaultType }{@code >}}
     * 
     * @param fault the {@link UnableToDestroyPullPointFaultType} object to "convert to" JAXBElement
     * @return a {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.base.UnableToDestroyPullPointFaultType }{@code >}} representation
     * @throws WSNotificationException
     */
    public abstract JAXBElement<?> createUnableToDestroyPullPointFault(UnableToDestroyPullPointFaultType fault) throws WSNotificationException; 
     
	/**
	 * create an instance of the {@link UnableToDestroySubscriptionFaultType} class
	 * 
	 * @return a new {@link UnableToDestroySubscriptionFaultType} object
	 * @throws WSNotificationException
	 */
    public abstract UnableToDestroySubscriptionFaultType createUnableToDestroySubscriptionFaultType() throws WSNotificationException;
     
    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.base.UnableToDestroySubscriptionFaultType }{@code >}}
     * 
     * @param fault the {@link UnableToDestroySubscriptionFaultType} object to "convert to" JAXBElement
     * @return a {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.base.UnableToDestroySubscriptionFaultType }{@code >}} representation
     * @throws WSNotificationException
     */
   public abstract JAXBElement<?> createUnableToDestroySubscriptionFault(UnableToDestroySubscriptionFaultType fault) throws WSNotificationException;     
    
	/**
	 * create an instance of the {@link UnableToGetMessagesFaultType} class
	 * 
	 * @return a new {@link UnableToGetMessagesFaultType} object
	 * @throws WSNotificationException
	 */
    public abstract UnableToGetMessagesFaultType createUnableToGetMessagesFaultType() throws WSNotificationException;
    
    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.base.UnableToGetMessagesFaultType }{@code >}}
     * 
     * @param fault the {@link UnableToGetMessagesFaultType} object to "convert to" JAXBElement
     * @return a {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.base.UnableToGetMessagesFaultType }{@code >}} representation
     * @throws WSNotificationException
     */
    public abstract JAXBElement<?> createUnableToGetMessagesFault(UnableToGetMessagesFaultType fault) throws WSNotificationException;
    
	/**
	 * create an instance of the {@link UnacceptableInitialTerminationTimeFaultType} class
	 * 
	 * @return a new {@link UnacceptableInitialTerminationTimeFaultType} object
	 * @throws WSNotificationException
	 */
    public abstract UnacceptableInitialTerminationTimeFaultType createUnacceptableInitialTerminationTimeFaultType() throws WSNotificationException;
    
    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.base.UnacceptableInitialTerminationTimeFaultType }{@code >}}
     * 
     * @param fault the {@link UnacceptableInitialTerminationTimeFaultType} object to "convert to" JAXBElement
     * @return a {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.base.UnacceptableInitialTerminationTimeFaultType }{@code >}} representation
     * @throws WSNotificationException
     */   
    public abstract JAXBElement<?> createUnacceptableInitialTerminationTimeFault(UnacceptableInitialTerminationTimeFaultType fault) throws WSNotificationException;
    
	/**
	 * create an instance of the {@link UnacceptableTerminationTimeFaultType} class
	 * 
	 * @return a new {@link UnacceptableTerminationTimeFaultType} object
	 * @throws WSNotificationException
	 */
    public abstract UnacceptableTerminationTimeFaultType createUnacceptableTerminationTimeFaultType() throws WSNotificationException;
   
    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.base.UnacceptableTerminationTimeFaultType }{@code >}}
     * 
     * @param fault the {@link UnacceptableTerminationTimeFaultType} object to "convert to" JAXBElement
     * @return a {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.base.UnacceptableTerminationTimeFaultType }{@code >}} representation
     * @throws WSNotificationException
     */
    public abstract JAXBElement<?> createUnacceptableTerminationTimeFault(UnacceptableTerminationTimeFaultType fault) throws WSNotificationException;
    
	/**
	 * create an instance of the {@link UnrecognizedPolicyRequestFaultType} class
	 * 
	 * @return a new {@link UnrecognizedPolicyRequestFaultType} object
	 * @throws WSNotificationException
	 */
    public abstract UnrecognizedPolicyRequestFaultType createUnrecognizedPolicyRequestFaultType() throws WSNotificationException;
    
    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.base.UnrecognizedPolicyRequestFaultType }{@code >}}
     * 
     * @param fault the {@link UnrecognizedPolicyRequestFaultType} object to "convert to" JAXBElement
     * @return a {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.base.UnrecognizedPolicyRequestFaultType }{@code >}} representation
     * @throws WSNotificationException
     */
   
    public abstract JAXBElement<?> createUnrecognizedPolicyRequestFault(UnrecognizedPolicyRequestFaultType fault) throws WSNotificationException;
    
	/**
	 * create an instance of the {@link UnsupportedPolicyRequestFaultType} class
	 * 
	 * @return a new {@link UnsupportedPolicyRequestFaultType} object
	 * @throws WSNotificationException
	 */
    public abstract UnsupportedPolicyRequestFaultType createUnsupportedPolicyRequestFaultType() throws WSNotificationException;
    
    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.base.UnsupportedPolicyRequestFaultType }{@code >}}
     * 
     * @param fault the {@link UnsupportedPolicyRequestFaultType} object to "convert to" JAXBElement
     * @return a {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.base.UnsupportedPolicyRequestFaultType }{@code >}} representation
     * @throws WSNotificationException
     */   
    public abstract JAXBElement<?> createUnsupportedPolicyRequestFault(UnsupportedPolicyRequestFaultType fault) throws WSNotificationException;
    
    // =============== WS-BrokeredNotification ===========
    
	/**
	 * create an instance of the {@link RegisterPublisher} class
	 * 
	 * @return a new {@link RegisterPublisher} object
	 * @throws WSNotificationException
	 */
    public abstract RegisterPublisher createRegisterPublisher() throws WSNotificationException;
    
	/**
	 * create an instance of the {@link RegisterPublisherResponse} class
	 * 
	 * @return a new {@link RegisterPublisherResponse} object
	 * @throws WSNotificationException
	 */
    public abstract RegisterPublisherResponse createRegisterPublisherResponse() throws WSNotificationException;
    
	/**
	 * create an instance of the {@link DestroyRegistration} class
	 * 
	 * @return a new {@link DestroyRegistration} object
	 * @throws WSNotificationException
	 */
    public abstract DestroyRegistration createDestroyRegistration() throws WSNotificationException;
    
	/**
	 * create an instance of the {@link DestroyRegistrationResponse} class
	 * 
	 * @return a new {@link DestroyRegistrationResponse} object
	 * @throws WSNotificationException
	 */
    public abstract DestroyRegistrationResponse createDestroyRegistrationResponse() throws WSNotificationException;
    
	/**
	 * create an instance of the {@link PublisherRegistrationRP} class
	 * 
	 * @return a new {@link PublisherRegistrationRP} object
	 * @throws WSNotificationException
	 */
    public abstract PublisherRegistrationRP createPublisherRegistrationRP() throws WSNotificationException;
    
    // ~~~ WS-BrokeredNotification faults ~~~
    
	/**
	 * create an instance of the {@link PublisherRegistrationRejectedFaultType} class
	 * 
	 * @return a new {@link PublisherRegistrationRejectedFaultType} object
	 * @throws WSNotificationException
	 */
    public abstract PublisherRegistrationRejectedFaultType createPublisherRegistrationRejectedFaultType() throws WSNotificationException;
    
    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.brokered.PublisherRegistrationFailedFaultType }{@code >}}
     * 
     * @param fault the {@link PublisherRegistrationFailedFaultType} object to "convert to" JAXBElement
     * @return a {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.brokered.PublisherRegistrationRejectedFaultType }{@code >}} representation
     * @throws WSNotificationException
     */
    public abstract JAXBElement<?> createPublisherRegistrationRejectedFault(PublisherRegistrationRejectedFaultType fault) throws WSNotificationException;
    
	/**
	 * create an instance of the {@link PublisherRegistrationFailedFaultType} class
	 * 
	 * @return a new {@link PublisherRegistrationFailedFaultType} object
	 * @throws WSNotificationException
	 */
    public abstract PublisherRegistrationFailedFaultType createPublisherRegistrationFailedFaultType() throws WSNotificationException;

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.brokered.PublisherRegistrationFailedFaultType }{@code >}}
     * 
     * @param fault the {@link PublisherRegistrationFailedFaultType} object to "convert to" JAXBElement
     * @return a {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.brokered.PublisherRegistrationFailedFaultType }{@code >}} representation
     * @throws WSNotificationException
     */
    public abstract JAXBElement<?> createPublisherRegistrationFailedFault(PublisherRegistrationFailedFaultType fault) throws WSNotificationException;
    
	/**
	 * create an instance of the {@link ResourceNotDestroyedFaultType} class
	 * 
	 * @return a new {@link ResourceNotDestroyedFaultType} object
	 * @throws WSNotificationException
	 */
    public abstract ResourceNotDestroyedFaultType createResourceNotDestroyedFaultType() throws WSNotificationException;
   
    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.brokered.ResourceNotDestroyedFaultType }{@code >}}
     * 
     * @param fault the {@link ResourceNotDestroyedFaultType} object to "convert to" JAXBElement
     * @return a {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.brokered.ResourceNotDestroyedFaultType }{@code >}} representation
     * @throws WSNotificationException
     */
    public abstract JAXBElement<?> createResourceNotDestroyedFault(ResourceNotDestroyedFaultType fault) throws WSNotificationException;
    
    // ============== WS-Topics ============
    
	/**
	 * create an instance of the {@link TopicType} class
	 * 
	 * @return a new {@link TopicType} object
	 * @throws WSNotificationException
	 */
    public abstract TopicType createTopicType() throws WSNotificationException ;
    
	/**
	 * create an instance of the {@link TopicNamespaceType} class
	 * 
	 * @return a new {@link TopicNamespaceType} object
	 * @throws WSNotificationException
	 */
    public abstract TopicNamespaceType createTopicNamespaceType() throws WSNotificationException;
    
    // =============== WS-BaseFaults =============
    
	/**
	 * create an instance of the {@link BaseFaultType} class
	 * 
	 * @return a new {@link BaseFaultType} object
	 * @throws WSNotificationException
	 */
    public abstract BaseFaultType createBaseFaultType() throws WSNotificationException;
    
	/**
	 * create an instance of the {@link BaseFaultDescriptionType} class
	 * 
	 * @return a new {@link BaseFaultDescriptionType} object
	 * @throws WSNotificationException
	 */
    public abstract BaseFaultDescriptionType createBaseFaultDescriptionType() throws WSNotificationException;
    
    // =============== WS-Resource ===============
    // ~~~ WS-Resource faults ~~~
    
	/**
	 * create an instance of the {@link ResourceUnknownFaultType} class
	 * 
	 * @return a new {@link ResourceUnknownFaultType} object
	 * @throws WSNotificationException
	 */
    public abstract ResourceUnknownFaultType createResourceUnknownFaultType() throws WSNotificationException;
    
    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.resource.ResourceUnknownFaultType }{@code >}}
     * 
     * @param fault the {@link ResourceUnknownFaultType} object to "convert to" JAXBElement
     * @return a {@link JAXBElement }{@code <}{@link com.ebmwebsourcing.wsstar.notification.definition.resource.ResourceUnknownFaultType }{@code >}} representation
     * @throws WSNotificationException
     */
    public abstract JAXBElement<?> createResourceUnknownFault(ResourceUnknownFaultType fault) throws WSNotificationException;	
    
}
