/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.Logger;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.wsstar.notification.definition.basefaults.impl.BaseFaultTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnacceptableTerminationTimeFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;

public class UnacceptableTerminationTimeFaultTypeImpl extends BaseFaultTypeImpl
		implements UnacceptableTerminationTimeFaultType {

	private static final long serialVersionUID = 1L;
	private static Logger log = Logger.getLogger(UnacceptableTerminationTimeFaultTypeImpl.class.getName());

	public UnacceptableTerminationTimeFaultTypeImpl(com.ebmwebsourcing.wsstar.notification.definition.base.UnacceptableTerminationTimeFaultType model,
			AbstractSchemaElementImpl parent) throws WSNotificationException {
		super(model, parent);
	}

	public Date getMaximumTime() throws WSNotificationException {
		Date result = null;
		
		XMLGregorianCalendar xmlGCal = 
			((com.ebmwebsourcing.wsstar.notification.definition.base.UnacceptableTerminationTimeFaultType)this.model).getMaximumTime();
		
		if (xmlGCal != null)
			result = xmlGCal.toGregorianCalendar().getTime();
		
		return result;
	}
	
	public Date getMinimumTime() throws WSNotificationException {
		Date result = null;
		
		XMLGregorianCalendar xmlGCal = 
			((com.ebmwebsourcing.wsstar.notification.definition.base.UnacceptableTerminationTimeFaultType)this.model).getMinimumTime();
		
		if (xmlGCal != null)
			result = xmlGCal.toGregorianCalendar().getTime();
		
		return result;
	}
	
	public void setMaximumTime(Date value) throws WSNotificationException {
		
		GregorianCalendar gCal = new GregorianCalendar();
		gCal.setTime(value);
		
		try {
			((com.ebmwebsourcing.wsstar.notification.definition.base.UnacceptableTerminationTimeFaultType)this.model)
				.setMaximumTime(DatatypeFactory.newInstance().newXMLGregorianCalendar(gCal));
		} catch (DatatypeConfigurationException e) {			
			throw new WSNotificationException(e);
		}		
	}
	
	public void setMinimumTime(Date value) throws WSNotificationException {
		
		GregorianCalendar gCal = new GregorianCalendar();
		gCal.setTime(value);
		
		try {
			((com.ebmwebsourcing.wsstar.notification.definition.base.UnacceptableTerminationTimeFaultType)this.model)
				.setMinimumTime(DatatypeFactory.newInstance().newXMLGregorianCalendar(gCal));
		} catch (DatatypeConfigurationException e) {			
			throw new WSNotificationException(e);
		}
	}
	
		
}
