/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.extension.utils;

import javax.xml.namespace.QName;

/**
 * Constants found in xml schema file "specificTypesForNotification.xsd" 
 * 
 * @author Thierry Déjean - eBM WebSourcing
 */
public class WsnExtensionConstants {

	// ---------------- Move from WstopConstants.java (ws-notification-definition) ----
	public static final String EBM_RESOURCEIDS_PREFIX = "ebm";
	
	public static final String EBM_RESOURCEIDS_NAMESPACE_URI = "http://petals.ow2.org/ebmwebsourcing/specific/ResourceIds";
	
	private static final String EBM_TOPICS_EXTENSION_NAMESPACE_URI = "http://org.ow2.petals/ebmwebsourcing/specific/topicExtension";
	
	public static final QName RESOURCE_IDS_QNAME = new QName(EBM_RESOURCEIDS_NAMESPACE_URI, "ResourceIds",EBM_RESOURCEIDS_PREFIX);
	
	public static final QName REGISTRATION_ID_QNAME = new QName(EBM_RESOURCEIDS_NAMESPACE_URI, "RegistrationId",EBM_RESOURCEIDS_PREFIX);

	public static final QName SUBSCRIPTION_ID_QNAME = new QName(EBM_RESOURCEIDS_NAMESPACE_URI, "SubscriptionId",EBM_RESOURCEIDS_PREFIX);
	
	public static final QName CURRENT_MESSAGE_ID_QNAME = new QName(EBM_RESOURCEIDS_NAMESPACE_URI, "CurrentMessageId",EBM_RESOURCEIDS_PREFIX);
	
	public static final QName SUPPORTED_QNAME_ATTR = new QName(EBM_TOPICS_EXTENSION_NAMESPACE_URI, "supported", EBM_RESOURCEIDS_PREFIX);
	
	// ----------------------------------------------------
	
	public static final String WSNOTIFICATION_EXTENDED_TYPES_NAMESPACE = "http://www.ebmwebsourcing.com/wsnotification/specificTypes";
	
	public static final String WSNOTIFICATION_EXTENDED_TYPES_PREFIX = "ebm";
		
	public static final QName SOA_PARAMETER_QNAME = new QName(WSNOTIFICATION_EXTENDED_TYPES_NAMESPACE,"SOAParameter",WSNOTIFICATION_EXTENDED_TYPES_PREFIX);

	public static final String RESOURCES_UUID_ROOT_TAG = "ResourceUuidList";
	
	public static final QName RESOURCES_UUID_QNAME = new QName(WSNOTIFICATION_EXTENDED_TYPES_NAMESPACE,"ResourceUuidList",WSNOTIFICATION_EXTENDED_TYPES_PREFIX);

	public static final String XPATH_EXPRESSION_ROOT_TAG = "Xpath";
	
	public static final QName XPATHS_QNAME = new QName(WSNOTIFICATION_EXTENDED_TYPES_NAMESPACE,"Xpath",WSNOTIFICATION_EXTENDED_TYPES_PREFIX);

	public static final QName TRANSFORM_POLICY_QNAME = new QName(WSNOTIFICATION_EXTENDED_TYPES_NAMESPACE,"TransformPolicy",WSNOTIFICATION_EXTENDED_TYPES_PREFIX);

	public static final QName PROCESS_POLICY_QNAME = new QName(WSNOTIFICATION_EXTENDED_TYPES_NAMESPACE,"ProcessPolicy",WSNOTIFICATION_EXTENDED_TYPES_PREFIX);

	public static final QName CONTEXT_POLICY_QNAME = new QName(WSNOTIFICATION_EXTENDED_TYPES_NAMESPACE,"ContextPolicy",WSNOTIFICATION_EXTENDED_TYPES_PREFIX);

	public static final QName TERMINATION_TIME_QNAME = new QName(WSNOTIFICATION_EXTENDED_TYPES_NAMESPACE,"TerminationTime",WSNOTIFICATION_EXTENDED_TYPES_PREFIX);
}
